package org.xbib.interlibrary.z.swb;

import org.xbib.content.settings.Settings;
import org.xbib.interlibrary.action.resolve.ResolveRequest;
import org.xbib.interlibrary.api.service.ServiceArguments;
import org.xbib.interlibrary.common.DefaultBibliographicDescription;
import org.xbib.interlibrary.z.AbstractZResolveService;
import org.xbib.interlibrary.z.ZClientHelper;
import org.xbib.marc.Marc;
import org.xbib.marc.MarcField;
import org.xbib.marc.MarcRecord;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 */
public class ResolveService extends AbstractZResolveService {

    private static final Logger logger = Logger.getLogger(ResolveService.class.getName());

    protected ResolveService(Settings settings,
                             ServiceArguments arguments,
                             ZClientHelper client) {
        super(settings, arguments, client);
    }

    @Override
    protected void resolve(InputStream inputStream,
                           DefaultBibliographicDescription.Builder descriptionBuilder,
                           Map<String, Object> document) {
        String format = client.getSettings().get("connection.format");
        String type = client.getSettings().get("connection.type");
        Charset charset = Charset.forName(client.getSettings().get("connection.encoding"));
        Marc.Builder builder = Marc.builder()
                .setFormat(format)
                .setType(type)
                .setInputStream(inputStream)
                .setCharset(charset);
        for (MarcRecord marcRecord : builder.iterable()) {
            logger.log(Level.FINE, () -> "resolve: record = " + marcRecord);
            for (MarcField marcField : marcRecord.getFields("025")) {
                String zdbID = marcField.getFirstSubfieldValue("z");
                if (zdbID != null) {
                    descriptionBuilder.setSource("ZDB");
                    descriptionBuilder.setSourceId(zdbID);
                }
            }
            document.clear();
            document.putAll(marcRecord);
        }
    }

    @Override
    public String getName() {
        return "SWB";
    }

    @Override
    public ResolveRequest validate(ResolveRequest request) {
        return request;
    }
}
