/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.interlibrary.z.swb;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.content.settings.Settings;
import org.xbib.interlibrary.action.avail.AvailRequest;
import org.xbib.interlibrary.action.avail.AvailResponse;
import org.xbib.interlibrary.api.Library;
import org.xbib.interlibrary.api.service.ServiceArguments;
import org.xbib.interlibrary.common.util.MultiMap;
import org.xbib.interlibrary.z.AbstractZAvailService;
import org.xbib.interlibrary.z.ZClientHelper;
import org.xbib.marc.Marc;
import org.xbib.marc.MarcField;
import org.xbib.marc.MarcRecord;
import org.xbib.marc.label.RecordLabel;

public class AvailService
extends AbstractZAvailService {
    private static final Logger logger = Logger.getLogger(AvailService.class.getName());

    public AvailService(Settings settings, ServiceArguments arguments, ZClientHelper client) {
        super(settings, arguments, client);
    }

    protected List<String> getServices() {
        return Arrays.asList("SWB", "swb");
    }

    protected void processAvailServices(AvailRequest request, InputStream inputStream, MultiMap<String, Map<String, Object>> multiMap, AvailResponse response) {
        String format = this.client.getSettings().get("connection.format");
        String type = this.client.getSettings().get("connection.type");
        Charset charset = Charset.forName(this.client.getSettings().get("connection.encoding"));
        Marc.Builder builder = Marc.builder().setFormat(format).setType(type).setInputStream(inputStream).setCharset(charset);
        for (MarcRecord marcRecord : builder.iterable()) {
            if (request.isBibliographicDescriptionEnabled().booleanValue()) {
                response.getBibliographicDescription().clear();
                response.getBibliographicDescription().putAll(marcRecord);
            }
            logger.log(Level.FINE, () -> "avail: record = " + marcRecord);
            String sourceid = ((MarcField)marcRecord.getFields("001").get(0)).getValue();
            String carrierType = this.isOnline(marcRecord) ? "online resource" : "volume";
            List<MarcRecord> locs = this.extractLok(marcRecord);
            for (MarcRecord loc : locs) {
                String isil = null;
                String callnumber = null;
                LinkedHashMap<String, String> service = new LinkedHashMap<String, String>();
                for (MarcField marcField : loc.getFields("852")) {
                    String t;
                    String s = marcField.getFirstSubfieldValue("a");
                    if ("LFER".equals(s)) continue;
                    if (s != null && !s.isEmpty()) {
                        isil = s;
                    }
                    if ((t = marcField.getFirstSubfieldValue("c")) == null || t.isEmpty()) continue;
                    callnumber = t;
                }
                if (isil == null) continue;
                service.put("isil", isil);
                Library library = (Library)this.interlibraryConfiguration.getLibraries().get(isil);
                if (library != null) {
                    service.put("name", library.getName());
                    service.put("domain", library.getDomain().getName());
                    service.put("organization", library.getDomain().getOrganization());
                }
                service.put("carriertype", carrierType);
                service.put("type", "interlibrary");
                service.put("callnumber", callnumber);
                service.put("source", this.name);
                service.put("sourceid", sourceid);
                service.put("_id", isil);
                multiMap.put((Object)isil, service);
            }
        }
        logger.log(Level.FINE, () -> "multi map = " + multiMap);
    }

    protected String getIdentifierField() {
        return null;
    }

    protected List<String> getCreatorFields() {
        return null;
    }

    protected List<String> getTitleFields() {
        return null;
    }

    protected String getCountryField() {
        return null;
    }

    protected Map<String, Object> getCountryMap() {
        return null;
    }

    protected String getLanguageField() {
        return null;
    }

    protected Map<String, Object> getLanguageMap() {
        return null;
    }

    protected Map<String, Object> getMonographCodes() {
        return null;
    }

    protected Map<String, Object> getSerialCodes() {
        return null;
    }

    protected Map<String, Object> getStatusCodes() {
        return null;
    }

    protected boolean isOnline(MarcRecord marcRecord) {
        for (MarcField marcField : marcRecord.getFields("007")) {
            if (!this.isStartOf("cr", marcField.getValue())) continue;
            return true;
        }
        return false;
    }

    private List<MarcRecord> extractLok(MarcRecord marcRecord) {
        ArrayList<MarcRecord> marcRecords = new ArrayList<MarcRecord>();
        Marc.Builder marcBuilder = null;
        for (MarcField marcField : marcRecord.getFields("LOK")) {
            String value = marcField.getFirstSubfieldValue("0");
            if (value.startsWith("000")) {
                if (marcBuilder != null) {
                    marcRecords.add(marcBuilder.buildRecord());
                }
                marcBuilder = Marc.builder();
                RecordLabel recordLabel = RecordLabel.builder().from(value.substring(3).toCharArray()).setSubfieldIdentifierLength(2).build();
                marcBuilder.recordLabel(recordLabel);
                continue;
            }
            if (marcBuilder == null) continue;
            MarcField.Builder builder = MarcField.builder();
            builder.tag(value.substring(0, 3)).indicator(value.substring(3, 5));
            if (!value.substring(5).isEmpty()) {
                builder.value(marcBuilder.getRecordLabel(), value.substring(5));
            }
            if (!marcField.getSubfields().isEmpty()) {
                for (MarcField.Subfield subfield : marcField.getSubfields()) {
                    if (subfield.getId().equals("0")) continue;
                    builder.subfield(subfield);
                }
            }
            MarcField mf = builder.build();
            marcBuilder.addField(mf);
        }
        if (marcBuilder != null) {
            marcRecords.add(marcBuilder.buildRecord());
        }
        return marcRecords;
    }

    public String getName() {
        return "SWB";
    }
}

