/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.interlibrary.z.swb;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.content.settings.Settings;
import org.xbib.interlibrary.action.search.SearchRequest;
import org.xbib.interlibrary.api.service.ServiceArguments;
import org.xbib.interlibrary.z.AbstractZSearchService;
import org.xbib.interlibrary.z.ZClientHelper;
import org.xbib.marc.Marc;
import org.xbib.marc.MarcField;
import org.xbib.marc.MarcRecord;
import org.xbib.marc.label.RecordLabel;

public class SearchService
extends AbstractZSearchService {
    private static final Logger logger = Logger.getLogger(SearchService.class.getName());

    protected SearchService(Settings settings, ServiceArguments arguments, ZClientHelper client) {
        super(settings, arguments, client);
    }

    protected Map<String, Object> processSearchResult(InputStream inputStream) {
        Charset charset = Charset.forName(this.client.getSettings().get("connection.encoding"));
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Marc.Builder builder = Marc.builder().setInputStream(inputStream).setCharset(charset);
        for (MarcRecord marcRecord : builder.iterable()) {
            logger.log(Level.FINE, () -> "result: record = " + marcRecord);
            this.extractLok(marcRecord);
        }
        return map;
    }

    protected String getIdentifierField() {
        return "001";
    }

    protected List<String> getCreatorFields() {
        return Collections.singletonList("100");
    }

    protected List<String> getTitleFields() {
        return Collections.singletonList("245");
    }

    protected String getCountryField() {
        return "044";
    }

    protected Map<String, Object> getCountryMap() {
        return new AbstractZSearchService.DefaultHashMap();
    }

    protected String getLanguageField() {
        return "041";
    }

    protected Map<String, Object> getLanguageMap() {
        return new AbstractZSearchService.DefaultHashMap();
    }

    public String getName() {
        return "SWB";
    }

    public SearchRequest validate(SearchRequest request) {
        return request;
    }

    private List<MarcRecord> extractLok(MarcRecord marcRecord) {
        ArrayList<MarcRecord> marcRecords = new ArrayList<MarcRecord>();
        Marc.Builder marcBuilder = null;
        for (MarcField marcField : marcRecord.getFields("LOK")) {
            String value = marcField.getFirstSubfieldValue("0");
            if (value.startsWith("000")) {
                if (marcBuilder != null) {
                    marcRecords.add(marcBuilder.buildRecord());
                }
                marcBuilder = Marc.builder();
                RecordLabel recordLabel = RecordLabel.builder().from(value.substring(3).toCharArray()).setSubfieldIdentifierLength(2).build();
                marcBuilder.recordLabel(recordLabel);
                continue;
            }
            if (marcBuilder == null) continue;
            MarcField.Builder builder = MarcField.builder();
            builder.tag(value.substring(0, 3)).indicator(value.substring(3, 5));
            if (!value.substring(5).isEmpty()) {
                builder.value(marcBuilder.getRecordLabel(), value.substring(5));
            }
            if (!marcField.getSubfields().isEmpty()) {
                for (MarcField.Subfield subfield : marcField.getSubfields()) {
                    if (subfield.getId().equals("0")) continue;
                    builder.subfield(subfield);
                }
            }
            MarcField mf = builder.build();
            marcBuilder.addField(mf);
        }
        if (marcBuilder != null) {
            marcRecords.add(marcBuilder.buildRecord());
        }
        return marcRecords;
    }
}

