/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.io.compress.bgzf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import org.xbib.io.compress.bgzf.BGZFFilePointerUtil;
import org.xbib.io.compress.bgzf.BGZFStreamConstants;
import org.xbib.io.compress.bgzf.BinaryCodec;
import org.xbib.io.compress.bgzf.BlockCompressedInputStream;
import org.xbib.io.compress.bgzf.DeflaterFactory;

public class BlockCompressedOutputStream
extends OutputStream {
    private static int defaultCompressionLevel = 5;
    private static DeflaterFactory defaultDeflaterFactory = new DeflaterFactory();
    private final BinaryCodec codec;
    private final byte[] uncompressedBuffer = new byte[65498];
    private int numUncompressedBytes = 0;
    private final byte[] compressedBuffer = new byte[65518];
    private final Deflater deflater;
    private final Deflater noCompressionDeflater = new Deflater(0, true);
    private final CRC32 crc32 = new CRC32();
    private Path file = null;
    private long mBlockAddress = 0L;

    public static void setDefaultCompressionLevel(int compressionLevel) {
        if (compressionLevel < 0 || compressionLevel > 9) {
            throw new IllegalArgumentException("Invalid compression level: " + compressionLevel);
        }
        defaultCompressionLevel = compressionLevel;
    }

    public static int getDefaultCompressionLevel() {
        return defaultCompressionLevel;
    }

    public static void setDefaultDeflaterFactory(DeflaterFactory deflaterFactory) {
        if (deflaterFactory == null) {
            throw new IllegalArgumentException("null deflaterFactory");
        }
        defaultDeflaterFactory = deflaterFactory;
    }

    public static DeflaterFactory getDefaultDeflaterFactory() {
        return defaultDeflaterFactory;
    }

    public BlockCompressedOutputStream(String filename) throws FileNotFoundException {
        this(filename, defaultCompressionLevel);
    }

    public BlockCompressedOutputStream(File file) throws FileNotFoundException {
        this(file, defaultCompressionLevel);
    }

    public BlockCompressedOutputStream(String filename, int compressionLevel) throws FileNotFoundException {
        this(new File(filename), compressionLevel);
    }

    public BlockCompressedOutputStream(File file, int compressionLevel) throws FileNotFoundException {
        this(file, compressionLevel, defaultDeflaterFactory);
    }

    public BlockCompressedOutputStream(File file, int compressionLevel, DeflaterFactory deflaterFactory) throws FileNotFoundException {
        this.file = file.toPath();
        this.codec = new BinaryCodec(file, true);
        this.deflater = deflaterFactory.makeDeflater(compressionLevel, true);
    }

    public BlockCompressedOutputStream(OutputStream os) {
        this(os, (File)null, defaultCompressionLevel);
    }

    public BlockCompressedOutputStream(OutputStream os, Path file) {
        this(os, file, defaultCompressionLevel);
    }

    public BlockCompressedOutputStream(OutputStream os, File file, int compressionLevel) {
        this(os, file, compressionLevel, defaultDeflaterFactory);
    }

    public BlockCompressedOutputStream(OutputStream os, Path file, int compressionLevel) {
        this(os, file, compressionLevel, defaultDeflaterFactory);
    }

    public BlockCompressedOutputStream(OutputStream os, File file, int compressionLevel, DeflaterFactory deflaterFactory) {
        this(os, file != null ? file.toPath() : null, compressionLevel, deflaterFactory);
    }

    public BlockCompressedOutputStream(OutputStream os, Path file, int compressionLevel, DeflaterFactory deflaterFactory) {
        this.file = file;
        this.codec = new BinaryCodec(os);
        if (file != null) {
            this.codec.setOutputFileName(file.toAbsolutePath().toUri().toString());
        }
        this.deflater = deflaterFactory.makeDeflater(compressionLevel, true);
    }

    public static BlockCompressedOutputStream maybeBgzfWrapOutputStream(OutputStream output) {
        if (!(output instanceof BlockCompressedOutputStream)) {
            return new BlockCompressedOutputStream(output);
        }
        return (BlockCompressedOutputStream)output;
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int startIndex, int numBytes) throws IOException {
        while (numBytes > 0) {
            int bytesToWrite = Math.min(this.uncompressedBuffer.length - this.numUncompressedBytes, numBytes);
            System.arraycopy(bytes, startIndex, this.uncompressedBuffer, this.numUncompressedBytes, bytesToWrite);
            this.numUncompressedBytes += bytesToWrite;
            startIndex += bytesToWrite;
            numBytes -= bytesToWrite;
            if (this.numUncompressedBytes != this.uncompressedBuffer.length) continue;
            this.deflateBlock();
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.uncompressedBuffer[this.numUncompressedBytes++] = (byte)b;
        if (this.numUncompressedBytes == this.uncompressedBuffer.length) {
            this.deflateBlock();
        }
    }

    @Override
    public void flush() throws IOException {
        while (this.numUncompressedBytes > 0) {
            this.deflateBlock();
        }
        this.codec.getOutputStream().flush();
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean writeTerminatorBlock) throws IOException {
        this.flush();
        if (writeTerminatorBlock) {
            this.codec.writeBytes(BGZFStreamConstants.EMPTY_GZIP_BLOCK);
        }
        this.codec.close();
        if (writeTerminatorBlock) {
            if (this.file == null || !Files.isRegularFile(this.file, new LinkOption[0])) {
                return;
            }
            if (BlockCompressedInputStream.checkTermination(this.file) != BlockCompressedInputStream.FileTermination.HAS_TERMINATOR_BLOCK) {
                throw new IOException("Terminator block not found after closing BGZF file " + this.file);
            }
        }
    }

    public long getFilePointer() {
        return BGZFFilePointerUtil.makeFilePointer(this.mBlockAddress, this.numUncompressedBytes);
    }

    public long getPosition() {
        return this.getFilePointer();
    }

    private int deflateBlock() throws IOException {
        if (this.numUncompressedBytes == 0) {
            return 0;
        }
        int bytesToCompress = this.numUncompressedBytes;
        this.deflater.reset();
        this.deflater.setInput(this.uncompressedBuffer, 0, bytesToCompress);
        this.deflater.finish();
        int compressedSize = this.deflater.deflate(this.compressedBuffer, 0, this.compressedBuffer.length);
        if (!this.deflater.finished()) {
            this.noCompressionDeflater.reset();
            this.noCompressionDeflater.setInput(this.uncompressedBuffer, 0, bytesToCompress);
            this.noCompressionDeflater.finish();
            compressedSize = this.noCompressionDeflater.deflate(this.compressedBuffer, 0, this.compressedBuffer.length);
            if (!this.noCompressionDeflater.finished()) {
                throw new IllegalStateException("unpossible");
            }
        }
        this.crc32.reset();
        this.crc32.update(this.uncompressedBuffer, 0, bytesToCompress);
        int totalBlockSize = this.writeGzipBlock(compressedSize, bytesToCompress, this.crc32.getValue());
        this.numUncompressedBytes = 0;
        this.mBlockAddress += (long)totalBlockSize;
        return totalBlockSize;
    }

    private int writeGzipBlock(int compressedSize, int uncompressedSize, long crc) throws IOException {
        this.codec.writeByte((byte)31);
        this.codec.writeByte(139);
        this.codec.writeByte((byte)8);
        this.codec.writeByte(4);
        this.codec.writeInt(0);
        this.codec.writeByte(0);
        this.codec.writeByte(255);
        this.codec.writeShort((short)6);
        this.codec.writeByte((byte)66);
        this.codec.writeByte((byte)67);
        this.codec.writeShort((short)2);
        int totalBlockSize = compressedSize + 18 + 8;
        this.codec.writeShort((short)(totalBlockSize - 1));
        this.codec.writeBytes(this.compressedBuffer, 0, compressedSize);
        this.codec.writeInt((int)crc);
        this.codec.writeInt(uncompressedSize);
        return totalBlockSize;
    }
}

