/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.io.compress.bgzf;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xbib.io.compress.bgzf.SeekableStream;

public class SeekableBufferedStream
extends SeekableStream {
    public static final int DEFAULT_BUFFER_SIZE = 512000;
    private final int bufferSize;
    final SeekableStream wrappedStream;
    ExtBufferedInputStream bufferedStream;
    long position;

    public SeekableBufferedStream(SeekableStream stream, int bufferSize) {
        this.bufferSize = bufferSize;
        this.wrappedStream = stream;
        this.position = 0L;
        this.bufferedStream = new ExtBufferedInputStream(this.wrappedStream, bufferSize);
    }

    public SeekableBufferedStream(SeekableStream stream) {
        this(stream, 512000);
    }

    @Override
    public long length() {
        return this.wrappedStream.length();
    }

    @Override
    public long skip(long skipLength) throws IOException {
        if (skipLength < (long)this.bufferedStream.getBytesInBufferAvailable()) {
            long retval = this.bufferedStream.skip(skipLength);
            this.position += retval;
            return retval;
        }
        long position = this.position + skipLength;
        this.seek(position);
        return skipLength;
    }

    @Override
    public void seek(long position) throws IOException {
        this.position = position;
        this.wrappedStream.seek(position);
        this.bufferedStream = new ExtBufferedInputStream(this.wrappedStream, this.bufferSize);
    }

    @Override
    public int read() throws IOException {
        int b = this.bufferedStream.read();
        ++this.position;
        return b;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int nBytesRead = this.bufferedStream.read(buffer, offset, length);
        if (nBytesRead > 0) {
            this.position += (long)nBytesRead;
        }
        return nBytesRead;
    }

    @Override
    public void close() throws IOException {
        this.wrappedStream.close();
    }

    @Override
    public boolean eof() throws IOException {
        return this.position >= this.wrappedStream.length();
    }

    @Override
    public String getSource() {
        return this.wrappedStream.getSource();
    }

    @Override
    public long position() throws IOException {
        return this.position;
    }

    private static class ExtBufferedInputStream
    extends BufferedInputStream {
        private ExtBufferedInputStream(InputStream inputStream, int i) {
            super(inputStream, i);
        }

        int getBytesInBufferAvailable() {
            if (this.count == this.pos) {
                return 0;
            }
            return this.buf.length - this.pos;
        }
    }
}

