
package org.xbib.io.compress.xz;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

/**
 * Wraps a {@link java.io.RandomAccessFile RandomAccessFile}
 * in a SeekableInputStream.
 */
public class SeekableFileInputStream extends SeekableInputStream {
    /**
     * The RandomAccessFile that has been wrapped
     * into a SeekableFileInputStream.
     */
    protected RandomAccessFile randomAccessFile;

    /**
     * Creates a new seekable input stream that reads from the specified file.
     */
    public SeekableFileInputStream(File file) throws FileNotFoundException {
        randomAccessFile = new RandomAccessFile(file, "r");
    }

    /**
     * Creates a new seekable input stream that reads from a file with
     * the specified name.
     */
    public SeekableFileInputStream(String name) throws FileNotFoundException {
        randomAccessFile = new RandomAccessFile(name, "r");
    }

    /**
     * Creates a new seekable input stream from an existing
     * <code>RandomAccessFile</code> object.
     */
    public SeekableFileInputStream(RandomAccessFile randomAccessFile) {
        this.randomAccessFile = randomAccessFile;
    }

    /**
     * Calls {@link java.io.RandomAccessFile#read() randomAccessFile.read()}.
     */
    public int read() throws IOException {
        return randomAccessFile.read();
    }

    /**
     * Calls {@link java.io.RandomAccessFile#read(byte[]) randomAccessFile.read(buf)}.
     */
    public int read(byte[] buf) throws IOException {
        return randomAccessFile.read(buf);
    }

    /**
     * Calls
     * {@link java.io.RandomAccessFile#read(byte[], int, int)
     * randomAccessFile.read(buf, off, len)}.
     */
    public int read(byte[] buf, int off, int len) throws IOException {
        return randomAccessFile.read(buf, off, len);
    }

    /**
     * Calls {@link java.io.RandomAccessFile#close() randomAccessFile.close()}.
     */
    public void close() throws IOException {
        randomAccessFile.close();
    }

    /**
     * Calls {@link java.io.RandomAccessFile#length() randomAccessFile.length()}.
     */
    public long length() throws IOException {
        return randomAccessFile.length();
    }

    /**
     * Calls {@link java.io.RandomAccessFile#getFilePointer()
     * randomAccessFile.getFilePointer()}.
     */
    public long position() throws IOException {
        return randomAccessFile.getFilePointer();
    }

    /**
     * Calls {@link java.io.RandomAccessFile#seek(long) randomAccessFile.seek(long)}.
     */
    public void seek(long pos) throws IOException {
        randomAccessFile.seek(pos);
    }
}
