package org.xbib.io.compress.xz.check;

import org.xbib.io.compress.xz.UnsupportedOptionsException;
import org.xbib.io.compress.xz.XZ;

import java.security.NoSuchAlgorithmException;

public abstract class Check {

    int size;

    String name;

    public abstract void update(byte[] buf, int off, int len);

    public abstract byte[] finish();

    public void update(byte[] buf) {
        update(buf, 0, buf.length);
    }

    public int getSize() {
        return size;
    }

    public String getName() {
        return name;
    }

    public static Check getInstance(int checkType)
            throws UnsupportedOptionsException {
        switch (checkType) {
            case XZ.CHECK_NONE:
                return new None();

            case XZ.CHECK_CRC32:
                return new CRC32();

            case XZ.CHECK_CRC64:
                return new CRC64();

            case XZ.CHECK_SHA256:
                try {
                    return new SHA256();
                } catch (NoSuchAlgorithmException e) {
                }
                break;
        }
        throw new UnsupportedOptionsException(
                "Unsupported Check ID " + checkType);
    }
}
