/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.io.compress.xz;

import java.io.InputStream;
import org.xbib.io.compress.xz.DeltaCoder;
import org.xbib.io.compress.xz.DeltaInputStream;
import org.xbib.io.compress.xz.FilterDecoder;
import org.xbib.io.compress.xz.UnsupportedOptionsException;

class DeltaDecoder
extends DeltaCoder
implements FilterDecoder {
    private final int distance;

    DeltaDecoder(byte[] props) throws UnsupportedOptionsException {
        if (props.length != 1) {
            throw new UnsupportedOptionsException("Unsupported Delta filter properties");
        }
        this.distance = (props[0] & 0xFF) + 1;
    }

    @Override
    public int getMemoryUsage() {
        return 1;
    }

    @Override
    public InputStream getInputStream(InputStream in) {
        return new DeltaInputStream(in, this.distance);
    }
}

