/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jacc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.xbib.jacc.JaccJob;
import org.xbib.jacc.JaccResolver;
import org.xbib.jacc.JaccSettings;
import org.xbib.jacc.JaccTables;
import org.xbib.jacc.compiler.Handler;
import org.xbib.jacc.compiler.Phase;
import org.xbib.jacc.grammar.Grammar;
import org.xbib.jacc.grammar.Machine;

abstract class AbstractOutput
extends Phase {
    protected Grammar grammar;
    protected int numTs;
    protected int numNTs;
    protected Machine machine;
    int numSyms;
    int numStates;
    JaccTables tables;
    JaccResolver resolver;
    JaccSettings jaccSettings;

    AbstractOutput(Handler handler, JaccJob jaccjob) {
        super(handler);
        this.tables = jaccjob.getTables();
        this.machine = this.tables.getMachine();
        this.grammar = this.machine.getGrammar();
        this.numTs = this.grammar.getNumTs();
        this.numNTs = this.grammar.getNumNTs();
        this.numSyms = this.grammar.getNumSyms();
        this.numStates = this.machine.getNumStates();
        this.resolver = jaccjob.getResolver();
        this.jaccSettings = jaccjob.getJaccSettings();
    }

    static void indent(Writer writer, int i, String[] as) throws IOException {
        for (String a : as) {
            AbstractOutput.indent(writer, i, a);
        }
    }

    static void indent(Writer writer, int i) throws IOException {
        for (int j = 0; j < i; ++j) {
            writer.write("    ");
        }
    }

    static void indent(Writer writer, int i, String s) throws IOException {
        AbstractOutput.indent(writer, i);
        writer.write(s + "\n");
    }

    static void datestamp(Writer writer) throws IOException {
        writer.write("// Output created by jacc 2.1.0\n");
    }

    public void write(String s) throws IOException {
        File file = new File(s);
        File parent = file.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            return;
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(s), StandardCharsets.UTF_8);){
            this.write(writer);
        }
    }

    public abstract void write(Writer var1) throws IOException;
}

