/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jacc;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.jacc.JaccJob;
import org.xbib.jacc.JaccSettings;
import org.xbib.jacc.MachineType;
import org.xbib.jacc.ParserOutput;
import org.xbib.jacc.TextOutput;
import org.xbib.jacc.TokensOutput;
import org.xbib.jacc.compiler.ConsoleHandler;

public class Jacc {
    private static final Logger logger = Logger.getLogger(Jacc.class.getName());
    private String className = null;
    private InputStream inputStream = null;
    private InputStream errorDiagnostics = null;
    private InputStream parserInputs = null;
    private OutputStream outputStream;
    private String suffix = ".jacc";
    private JaccSettings jaccSettings = new JaccSettings();
    private boolean enableParserOutput = true;
    private boolean enableTokenOutput = true;
    private boolean enableVerboseMachineDescription = false;
    private boolean includeCalculations = false;
    private boolean includeStateNumbers = false;
    private String dir = null;

    public Jacc() {
        this.outputStream = System.out;
    }

    public void setIncludeCalculations(boolean includeCalculations) {
        this.includeCalculations = includeCalculations;
    }

    public void setEnableParserOutput(boolean enableParserOutput) {
        this.enableParserOutput = enableParserOutput;
    }

    public void setEnableTokenOutput(boolean enableTokenOutput) {
        this.enableTokenOutput = enableTokenOutput;
    }

    public void setEnableVerboseMachineDescription(boolean enableVerboseMachineDescription) {
        this.enableVerboseMachineDescription = enableVerboseMachineDescription;
    }

    public void setMachineType(MachineType machineType) {
        this.jaccSettings.setMachineType(machineType);
    }

    public void setIncludeStateNumbers(boolean includeStateNumbers) {
        this.includeStateNumbers = includeStateNumbers;
    }

    public void setName(String name) {
        this.className = name;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setErrorDiagnostics(InputStream errorDiagnostics) {
        this.errorDiagnostics = errorDiagnostics;
    }

    public InputStream getErrorDiagnostics() {
        return this.errorDiagnostics;
    }

    public void setParserInputs(InputStream parserInputs) {
        this.parserInputs = parserInputs;
    }

    public InputStream getParserInputs() {
        return this.parserInputs;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public static void main(String[] args) throws Exception {
        Jacc jacc = new Jacc();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-")) {
                if (arg.length() == 1) {
                    Jacc.usage("Missing command line options");
                }
                block15: for (int j = 1; j < arg.length(); ++j) {
                    switch (arg.charAt(j)) {
                        case 'f': {
                            jacc.setIncludeCalculations(true);
                            continue block15;
                        }
                        case 'p': {
                            jacc.setEnableParserOutput(false);
                            continue block15;
                        }
                        case 't': {
                            jacc.setEnableTokenOutput(false);
                            continue block15;
                        }
                        case 'v': {
                            jacc.setEnableVerboseMachineDescription(true);
                            continue block15;
                        }
                        case '0': {
                            jacc.setMachineType(MachineType.LR0);
                            continue block15;
                        }
                        case 's': {
                            jacc.setMachineType(MachineType.SLR1);
                            continue block15;
                        }
                        case 'a': {
                            jacc.setMachineType(MachineType.LALR1);
                            continue block15;
                        }
                        case 'n': {
                            jacc.setIncludeStateNumbers(true);
                            continue block15;
                        }
                        case 'e': {
                            if (i + 1 >= args.length) {
                                Jacc.usage("Missing filename for -e option");
                            }
                            jacc.setErrorDiagnostics(Files.newInputStream(Paths.get(args[++i], new String[0]), new OpenOption[0]));
                            continue block15;
                        }
                        case 'r': {
                            if (i + 1 >= args.length) {
                                Jacc.usage("Missing filename for -r option");
                            }
                            jacc.setParserInputs(Files.newInputStream(Paths.get(args[++i], new String[0]), new OpenOption[0]));
                            continue block15;
                        }
                        case 'd': {
                            if (i + 1 >= args.length) {
                                Jacc.usage("Missing directory for -d option");
                            }
                            jacc.setDir(args[++i]);
                            continue block15;
                        }
                        case 'o': {
                            if (i + 1 >= args.length) {
                                Jacc.usage("Missing filename for -o option");
                            }
                            jacc.setOutputStream(Files.newOutputStream(Paths.get(args[++i], new String[0]), new OpenOption[0]));
                            continue block15;
                        }
                        default: {
                            Jacc.usage("Unrecognized command line option " + arg.charAt(j));
                        }
                    }
                }
            }
            if (!arg.endsWith(jacc.getSuffix())) {
                Jacc.usage("Input file must have \"" + jacc.getSuffix() + "\" suffix");
                continue;
            }
            jacc.setInputStream(Files.newInputStream(Paths.get(arg, new String[0]), new OpenOption[0]));
        }
        if (jacc.getInputStream() == null) {
            Jacc.usage("No input file(s) specified");
        } else {
            jacc.execute();
        }
    }

    public void execute() throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.outputStream, StandardCharsets.UTF_8));
        ConsoleHandler consoleHandler = new ConsoleHandler();
        if (this.dir == null) {
            this.dir = ".";
        }
        if (!this.dir.endsWith("/")) {
            this.dir = this.dir + "/";
        }
        JaccJob job = new JaccJob(consoleHandler, writer, this.jaccSettings);
        job.parseGrammarStream(this.inputStream);
        job.buildTables();
        this.jaccSettings.fillBlanks(this.className);
        if (this.errorDiagnostics != null) {
            job.readErrorExamples(this.errorDiagnostics);
        }
        if (consoleHandler.getNumFailures() == 0) {
            if (this.enableParserOutput) {
                new ParserOutput(consoleHandler, job).write(this.dir + this.jaccSettings.getClassName() + ".java");
            }
            if (this.enableTokenOutput) {
                new TokensOutput(consoleHandler, job).write(this.dir + this.jaccSettings.getInterfaceName() + ".java");
            }
            if (this.enableVerboseMachineDescription) {
                new TextOutput(consoleHandler, job, this.includeCalculations).write(this.dir + this.jaccSettings.getClassName() + ".output");
            }
            if (this.parserInputs != null) {
                job.readRunExample(this.parserInputs, this.includeStateNumbers);
            }
        } else {
            writer.write("There were failures.\n");
        }
        ((Writer)writer).close();
    }

    private static void usage(String s) {
        logger.log(Level.INFO, s);
        String mesg = "usage: jacc [options] file.jacc ...\noptions (individually, or in combination):\n -p        do not generate parser\n -t        do not generate token specification\n -v        output text description of machine\n -f        show first/follow sets (with -h or -v)\n -a        treat as LALR(1) grammar (default)\n -s        treat as SLR(1) grammar\n -0        treat as LR(0) grammar\n -r file   run parser on input in file\n -n        show state numbers in parser output\n -e file   read error cases from file\n -d dir    output files to directory\n -o file   name of output file for parser runs\n";
        logger.log(Level.INFO, mesg);
    }
}

