/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jacc;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.xbib.jacc.JaccLexer;
import org.xbib.jacc.JaccParser;
import org.xbib.jacc.JaccResolver;
import org.xbib.jacc.JaccSettings;
import org.xbib.jacc.JaccTables;
import org.xbib.jacc.compiler.Failure;
import org.xbib.jacc.compiler.Handler;
import org.xbib.jacc.compiler.JavaSource;
import org.xbib.jacc.compiler.Phase;
import org.xbib.jacc.compiler.Position;
import org.xbib.jacc.compiler.Warning;
import org.xbib.jacc.grammar.Finitary;
import org.xbib.jacc.grammar.Grammar;
import org.xbib.jacc.grammar.LookaheadMachine;
import org.xbib.jacc.grammar.Parser;

class JaccJob
extends Phase {
    private JaccSettings jaccSettings;
    private JaccParser parser;
    private JaccTables tables;
    private JaccResolver resolver;
    private Writer out;

    JaccJob(Handler handler, Writer out, JaccSettings jaccSettings) {
        super(handler);
        this.out = out;
        this.jaccSettings = jaccSettings;
        this.parser = new JaccParser(handler, jaccSettings);
    }

    JaccSettings getJaccSettings() {
        return this.jaccSettings;
    }

    JaccTables getTables() {
        return this.tables;
    }

    JaccResolver getResolver() {
        return this.resolver;
    }

    void parseGrammarStream(InputStream inputStream) throws IOException {
        JaccLexer jacclexer = this.lexerFromInputStream(inputStream);
        if (jacclexer != null) {
            this.parser.parse(jacclexer);
            jacclexer.close();
        }
    }

    private JaccLexer lexerFromFile(String s) throws IOException {
        InputStreamReader filereader = new InputStreamReader((InputStream)new FileInputStream(s), StandardCharsets.UTF_8);
        JaccLexer jacclexer = new JaccLexer(this.getHandler(), new JavaSource(this.getHandler(), filereader));
        jacclexer.nextToken();
        return jacclexer;
    }

    private JaccLexer lexerFromInputStream(InputStream inputStream) throws IOException {
        InputStreamReader filereader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        JaccLexer jacclexer = new JaccLexer(this.getHandler(), new JavaSource(this.getHandler(), filereader));
        jacclexer.nextToken();
        return jacclexer;
    }

    void readErrorExamples(String s) throws IOException {
        this.out.write("Reading error examples from \"" + s + "\"");
        JaccLexer jacclexer = this.lexerFromFile(s);
        if (jacclexer != null) {
            this.parser.parseErrorExamples(jacclexer, this);
            jacclexer.close();
        }
    }

    void readErrorExamples(InputStream inputStream) throws IOException {
        JaccLexer jacclexer = this.lexerFromInputStream(inputStream);
        if (jacclexer != null) {
            this.parser.parseErrorExamples(jacclexer, this);
            jacclexer.close();
        }
    }

    void readRunExample(String s, boolean flag) throws IOException {
        this.out.write("Running example from \"" + s + "\"]\n");
        JaccLexer jacclexer = this.lexerFromFile(s);
        if (jacclexer != null) {
            this.runExample(this.parser.parseSymbols(jacclexer), flag);
            jacclexer.close();
        }
    }

    void readRunExample(InputStream inputStream, boolean flag) throws IOException {
        this.out.write("Running example from input stream\n");
        JaccLexer jacclexer = this.lexerFromInputStream(inputStream);
        if (jacclexer != null) {
            this.runExample(this.parser.parseSymbols(jacclexer), flag);
            jacclexer.close();
        }
    }

    void buildTables() {
        Grammar grammar = this.parser.getGrammar();
        if (grammar == null || !this.allDeriveFinite(grammar)) {
            return;
        }
        LookaheadMachine lookaheadmachine = this.jaccSettings.makeMachine(grammar);
        this.resolver = new JaccResolver(lookaheadmachine);
        this.tables = new JaccTables(lookaheadmachine, this.resolver);
        if (this.tables.getProdUnused() > 0) {
            this.report(new Warning(this.tables.getProdUnused() + " rules never reduced"));
        }
        if (this.resolver.getNumSRConflicts() > 0 || this.resolver.getNumRRConflicts() > 0) {
            this.report(new Warning("conflicts: " + this.resolver.getNumSRConflicts() + " shift/reduce, " + this.resolver.getNumRRConflicts() + " reduce/reduce"));
        }
    }

    private boolean allDeriveFinite(Grammar grammar) {
        Finitary finitary = grammar.getFinitary();
        boolean flag = true;
        for (int i = 0; i < grammar.getNumNTs(); ++i) {
            if (finitary.isAt(i)) continue;
            flag = false;
            this.report(new Failure("No finite strings can be derived for " + grammar.getNonterminal(i)));
        }
        return flag;
    }

    private void runExample(int[] ai, boolean flag) throws IOException {
        Grammar grammar = this.parser.getGrammar();
        Parser parser1 = new Parser(this.tables, ai);
        this.out.write("start ");
        block7: while (true) {
            this.out.write(" :  ");
            parser1.display(this.out, flag);
            switch (parser1.step()) {
                case 0: {
                    this.out.write("Accept!\n");
                    return;
                }
                case 1: {
                    this.out.write("error in state ");
                    this.out.write(parser1.getState());
                    this.out.write(", next symbol ");
                    this.out.write(grammar.getSymbol(parser1.getNextSymbol()).toString());
                    return;
                }
                case 3: {
                    this.out.write("goto  ");
                    continue block7;
                }
                case 2: {
                    this.out.write("shift ");
                    continue block7;
                }
                case 4: {
                    this.out.write("reduce");
                    continue block7;
                }
            }
        }
    }

    void errorExample(Position position, String s, int[] ai) {
        int i;
        Parser p = new Parser(this.tables, ai);
        while ((i = p.step()) != 0 && i != 1) {
        }
        if (i == 0) {
            this.report(new Warning(position, "Example for \"" + s + "\" does not produce an error"));
        } else {
            int j;
            Grammar grammar = this.tables.getMachine().getGrammar();
            if (grammar.isNonterminal(j = p.getNextSymbol())) {
                this.report(new Warning(position, "Example for \"" + s + "\" reaches an error at the nonterminal " + grammar.getSymbol(j)));
            } else {
                int k = p.getState();
                if (!this.tables.errorAt(k, j)) {
                    this.report(new Failure(position, "Error example results in internal error"));
                } else {
                    String s1 = this.tables.errorSet(k, j, s);
                    if (s1 != null) {
                        this.report(new Warning(position, "Multiple errors are possible in state " + k + " on terminal " + grammar.getSymbol(j) + ":\n - " + s1 + "\n - " + s));
                    }
                }
            }
        }
    }
}

