/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jacc;

import java.io.IOException;
import org.xbib.jacc.JaccTokens;
import org.xbib.jacc.compiler.Failure;
import org.xbib.jacc.compiler.Handler;
import org.xbib.jacc.compiler.Source;
import org.xbib.jacc.compiler.SourceLexer;
import org.xbib.jacc.compiler.Warning;

class JaccLexer
extends SourceLexer
implements JaccTokens {
    private int lastLiteral;

    JaccLexer(Handler handler, Source source) throws IOException {
        super(handler, source);
    }

    @Override
    public int nextToken() throws IOException {
        block16: while (true) {
            this.skipWhitespace();
            this.markPosition();
            this.lexemeText = null;
            switch (this.c) {
                case -1: {
                    this.token = 0;
                    return this.token;
                }
                case 58: {
                    this.nextChar();
                    this.token = 58;
                    return this.token;
                }
                case 59: {
                    this.nextChar();
                    this.token = 59;
                    return this.token;
                }
                case 124: {
                    this.nextChar();
                    this.token = 124;
                    return this.token;
                }
                case 60: {
                    this.nextChar();
                    this.token = 60;
                    return this.token;
                }
                case 62: {
                    this.nextChar();
                    this.token = 62;
                    return this.token;
                }
                case 91: {
                    this.nextChar();
                    this.token = 91;
                    return this.token;
                }
                case 93: {
                    this.nextChar();
                    this.token = 93;
                    return this.token;
                }
                case 46: {
                    this.nextChar();
                    this.token = 46;
                    return this.token;
                }
                case 37: {
                    if (this.directive() == -1) continue block16;
                    return this.token;
                }
                case 34: {
                    if (this.string() == -1) continue block16;
                    return this.token;
                }
                case 39: {
                    if (this.literal() == -1) continue block16;
                    return this.token;
                }
                case 123: {
                    if (this.action() == -1) continue block16;
                    return this.token;
                }
                case 47: {
                    this.skipComment();
                    continue block16;
                }
            }
            if (Character.isJavaIdentifierStart((char)this.c)) {
                return this.identifier();
            }
            if (Character.isDigit((char)this.c)) {
                return this.number();
            }
            this.illegalCharacter();
            this.nextChar();
        }
    }

    String readWholeLine() throws IOException {
        if (this.line == null) {
            return null;
        }
        String s = this.line;
        if (this.col > 0) {
            s = s.substring(this.col);
        }
        this.nextLine();
        return s;
    }

    String readCodeLine() throws IOException {
        while (this.isWhitespace(this.c)) {
            this.nextChar();
        }
        return this.readWholeLine();
    }

    private boolean isWhitespace(int i) {
        return i == 32 || i == 12;
    }

    private void skipWhitespace() throws IOException {
        while (this.isWhitespace(this.c)) {
            this.nextChar();
        }
        while (this.c == 10) {
            this.nextLine();
            while (this.isWhitespace(this.c)) {
                this.nextChar();
            }
        }
    }

    private void skipComment() throws IOException {
        this.nextChar();
        if (this.c == 47) {
            this.nextLine();
        } else {
            if (this.c == 42) {
                this.nextChar();
                while (true) {
                    if (this.c == 42) {
                        do {
                            this.nextChar();
                        } while (this.c == 42);
                        if (this.c == 47) {
                            this.nextChar();
                            return;
                        }
                    }
                    if (this.c == -1) {
                        this.report(new Failure(this.getPos(), "Unterminated comment"));
                        return;
                    }
                    if (this.c == 10) {
                        this.nextLine();
                        continue;
                    }
                    this.nextChar();
                }
            }
            this.report(new Failure(this.getPos(), "Illegal comment format"));
        }
    }

    private int identifier() {
        int i = this.col;
        do {
            this.nextChar();
        } while (this.c != -1 && Character.isJavaIdentifierPart((char)this.c));
        this.lexemeText = this.line.substring(i, this.col);
        this.token = 3;
        return this.token;
    }

    private int directive() throws IOException {
        this.nextChar();
        if (this.c == 37) {
            this.nextChar();
            this.token = 1;
            return this.token;
        }
        if (Character.isJavaIdentifierStart((char)this.c)) {
            this.identifier();
            switch (this.lexemeText) {
                case "token": {
                    this.token = 8;
                    return this.token;
                }
                case "type": {
                    this.token = 9;
                    return this.token;
                }
                case "prec": {
                    this.token = 10;
                    return this.token;
                }
                case "left": {
                    this.token = 11;
                    return this.token;
                }
                case "right": {
                    this.token = 12;
                    return this.token;
                }
                case "nonassoc": {
                    this.token = 13;
                    return this.token;
                }
                case "start": {
                    this.token = 14;
                    return this.token;
                }
                case "package": {
                    this.token = 15;
                    return this.token;
                }
                case "extends": {
                    this.token = 18;
                    return this.token;
                }
                case "implements": {
                    this.token = 19;
                    return this.token;
                }
                case "semantic": {
                    this.token = 20;
                    return this.token;
                }
                case "get": {
                    this.token = 21;
                    return this.token;
                }
                case "next": {
                    this.token = 22;
                    return this.token;
                }
                case "class": {
                    this.token = 16;
                    return this.token;
                }
                case "interface": {
                    this.token = 17;
                    return this.token;
                }
            }
            this.report(new Failure(this.getPos(), "Unrecognized directive"));
            return -1;
        }
        if (this.c == 123) {
            this.nextChar();
            return this.code();
        }
        this.report(new Failure(this.getPos(), "Illegal directive syntax"));
        return -1;
    }

    private int code() throws IOException {
        int i = this.col;
        StringBuilder sb = null;
        while (true) {
            if (this.c == 37) {
                do {
                    this.nextChar();
                } while (this.c == 37);
                if (this.c == 125) {
                    this.lexemeText = this.endBuffer(sb, i, this.col - 1);
                    this.nextChar();
                    this.token = 2;
                    return this.token;
                }
            }
            if (this.c == -1) {
                this.report(new Failure(this.getPos(), "Code fragment terminator %} not found"));
                this.lexemeText = this.endBuffer(sb, i, this.col);
                this.token = 2;
                return this.token;
            }
            if (this.c == 10) {
                if (sb == null) {
                    sb = new StringBuilder(this.line.substring(i, this.col));
                } else {
                    sb.append('\n');
                    sb.append(this.line);
                }
                this.nextLine();
                continue;
            }
            this.nextChar();
        }
    }

    private String endBuffer(StringBuilder sb, int i, int j) {
        if (sb == null) {
            return this.line.substring(i, j);
        }
        sb.append('\n');
        if (this.line != null) {
            sb.append(this.line.substring(0, j));
        }
        return sb.toString();
    }

    int getLastLiteral() {
        return this.lastLiteral;
    }

    private int number() {
        int i = this.col;
        int j = 0;
        int k = Character.digit((char)this.c, 10);
        do {
            j = 10 * j + k;
            this.nextChar();
        } while ((k = Character.digit((char)this.c, 10)) >= 0);
        this.lexemeText = this.line.substring(i, this.col);
        this.lastLiteral = j;
        this.token = 6;
        return this.token;
    }

    private int string() {
        this.nextChar();
        int i = this.col;
        while (this.c != 34 && this.c != 10 && this.c != -1) {
            if (this.c == 92) {
                this.escapeChar();
                continue;
            }
            this.nextChar();
        }
        this.lexemeText = this.line.substring(i, this.col);
        if (this.c == 34) {
            this.nextChar();
        } else {
            this.report(new Warning(this.getPos(), "Missing \" on string literal"));
        }
        this.token = 5;
        return this.token;
    }

    private int literal() {
        int i = this.col;
        this.nextChar();
        if (this.c == 92) {
            this.escapeChar();
        } else if (this.c != 39 && this.c != 10 && this.c != -1) {
            this.lastLiteral = this.c;
            this.nextChar();
        } else {
            this.report(new Failure(this.getPos(), "Illegal character literal syntax"));
            return -1;
        }
        if (this.c == 39) {
            this.nextChar();
        } else {
            this.report(new Warning(this.getPos(), "Missing ' on character literal"));
        }
        this.lexemeText = this.line.substring(i, this.col);
        this.token = 4;
        return this.token;
    }

    private void escapeChar() {
        this.nextChar();
        switch (this.c) {
            case 34: 
            case 39: 
            case 92: 
            case 98: 
            case 102: 
            case 110: 
            case 114: 
            case 116: {
                this.lastLiteral = this.c;
                this.nextChar();
                return;
            }
        }
        int i = Character.digit((char)this.c, 8);
        if (i >= 0) {
            this.lastLiteral = 0;
            int j = i >= 4 ? 2 : 3;
            do {
                this.lastLiteral = (this.lastLiteral << 3) + i;
                this.nextChar();
            } while ((i = Character.digit((char)this.c, 8)) >= 0 && --j > 0);
        } else {
            this.report(new Failure(this.getPos(), "Syntax error in escape sequence"));
        }
    }

    private int action() throws IOException {
        int i = this.col;
        int j = 0;
        StringBuilder sb = null;
        while (true) {
            if (this.c == 125) {
                if (--j == 0) {
                    this.nextChar();
                    this.lexemeText = this.endBuffer(sb, i, this.col);
                    this.token = 7;
                    return this.token;
                }
            } else if (this.c == 123) {
                ++j;
            }
            if (this.c == -1) {
                this.report(new Failure(this.getPos(), "Unterminated action"));
                this.lexemeText = this.endBuffer(sb, i, this.col);
                this.token = 7;
                return this.token;
            }
            if (this.c == 10) {
                if (sb == null) {
                    sb = new StringBuilder(this.line.substring(i, this.col));
                } else {
                    sb.append('\n');
                    sb.append(this.line);
                }
                this.nextLine();
                continue;
            }
            this.nextChar();
        }
    }

    private void illegalCharacter() {
        this.report(new Warning(this.getPos(), "Ignoring illegal character"));
    }
}

