/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jacc.compiler;

import java.io.IOException;
import org.xbib.jacc.compiler.Handler;
import org.xbib.jacc.compiler.Lexer;
import org.xbib.jacc.compiler.Position;
import org.xbib.jacc.compiler.Source;
import org.xbib.jacc.compiler.SourcePosition;

public abstract class SourceLexer
extends Lexer {
    protected String line;
    protected int col = -1;
    protected int c;
    private Source source;
    private SourcePosition pos;

    public SourceLexer(Handler handler, Source source) throws IOException {
        super(handler);
        this.source = source;
        this.pos = new SourcePosition(source);
        this.line = source.readLine();
        this.nextChar();
    }

    @Override
    public Position getPos() {
        return this.pos.copy();
    }

    protected void markPosition() {
        this.pos.updateCoords(this.source.getLineNo(), this.col);
    }

    protected void nextLine() throws IOException {
        this.line = this.source.readLine();
        this.col = -1;
        this.nextChar();
    }

    protected int nextChar() {
        if (this.line == null) {
            this.c = -1;
            this.col = 0;
        } else {
            this.c = ++this.col >= this.line.length() ? 10 : (int)this.line.charAt(this.col);
        }
        return this.c;
    }

    @Override
    public void close() throws IOException {
        if (this.source != null) {
            this.source.close();
            this.source = null;
        }
    }
}

