/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jacc.grammar;

import java.io.IOException;
import java.io.Writer;
import org.xbib.jacc.grammar.Grammar;

public class LR0Items {
    private Grammar grammar;
    private int numItems;
    private Item[] items;
    private int[][] firstKernel;

    LR0Items(Grammar grammar) {
        this.grammar = grammar;
        int i = grammar.getNumNTs();
        this.numItems = 2;
        this.firstKernel = new int[i][];
        for (int j = 0; j < i; ++j) {
            Grammar.Prod[] aprod = grammar.getProds(j);
            this.firstKernel[j] = new int[aprod.length];
            for (int l = 0; l < aprod.length; ++l) {
                int j1 = aprod[l].getRhs().length;
                this.firstKernel[j][l] = this.numItems;
                this.numItems += j1 != 0 ? j1 : 1;
            }
        }
        this.items = new Item[this.numItems];
        this.numItems = 0;
        new Item(-1, 0, 0);
        new Item(-1, 0, 1);
        for (int k = 0; k < i; ++k) {
            Grammar.Prod[] aprod1 = grammar.getProds(k);
            for (int i1 = 0; i1 < aprod1.length; ++i1) {
                int[] ai = aprod1[i1].getRhs();
                for (int k1 = 1; k1 < ai.length; ++k1) {
                    new Item(k, i1, k1);
                }
                new Item(k, i1, ai.length);
            }
        }
    }

    public Item getItem(int i) {
        return this.items[i];
    }

    int getStartItem() {
        return 0;
    }

    int getEndItem() {
        return 1;
    }

    int getFirstKernel(int i, int j) {
        return this.firstKernel[i][j];
    }

    public class Item {
        private int itemNo;
        private int lhs;
        private int prodNo;
        private int pos;

        private Item(int i, int j, int k) {
            this.itemNo = LR0Items.this.numItems;
            this.lhs = i;
            this.prodNo = j;
            this.pos = k;
            ((LR0Items)LR0Items.this).items[((LR0Items)LR0Items.this).numItems++] = this;
        }

        int getLhs() {
            return this.lhs;
        }

        int getProdNo() {
            return this.prodNo;
        }

        public int getSeqNo() {
            return this.getProd().getSeqNo();
        }

        public Grammar.Prod getProd() {
            return LR0Items.this.grammar.getProds(this.lhs)[this.prodNo];
        }

        int getPos() {
            return this.pos;
        }

        boolean canGoto() {
            if (this.lhs < 0) {
                return this.pos == 0;
            }
            return this.pos != this.getProd().getRhs().length;
        }

        boolean canReduce() {
            return this.lhs >= 0 && this.pos == this.getProd().getRhs().length;
        }

        boolean canAccept() {
            return this.lhs < 0 && this.pos == 1;
        }

        int getNextItem() {
            if (this.lhs >= 0) {
                return this.itemNo + 1;
            }
            return 1;
        }

        int getNextSym() {
            if (this.lhs >= 0) {
                return LR0Items.this.grammar.getProds(this.lhs)[this.prodNo].getRhs()[this.pos];
            }
            return 0;
        }

        public void display(Writer writer) throws IOException {
            String s;
            if (this.lhs < 0) {
                if (this.pos == 0) {
                    writer.write("$accept : _" + LR0Items.this.grammar.getStart() + " " + LR0Items.this.grammar.getEnd());
                } else {
                    writer.write("$accept : " + LR0Items.this.grammar.getStart() + "_" + LR0Items.this.grammar.getEnd());
                }
                return;
            }
            writer.write(LR0Items.this.grammar.getSymbol(this.lhs).toString());
            writer.write(" : ");
            Grammar.Prod prod = LR0Items.this.grammar.getProds(this.lhs)[this.prodNo];
            int[] ai = prod.getRhs();
            writer.write(LR0Items.this.grammar.displaySymbols(ai, 0, this.pos, "", " "));
            writer.write("_");
            if (this.pos < ai.length) {
                writer.write(LR0Items.this.grammar.displaySymbols(ai, this.pos, ai.length, "", " "));
            }
            if ((s = prod.getLabel()) != null) {
                writer.write("    (");
                writer.write(s);
                writer.write(41);
            }
        }
    }
}

