/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jacc.grammar;

import java.io.IOException;
import java.io.Writer;
import org.xbib.jacc.grammar.Analysis;
import org.xbib.jacc.grammar.Grammar;
import org.xbib.jacc.util.BitSet;

final class Left
extends Analysis {
    private Grammar grammar;
    private int[][] left;

    Left(Grammar grammar1) {
        super(grammar1.getComponents());
        this.grammar = grammar1;
        int numNTs = grammar1.getNumNTs();
        this.left = new int[numNTs][];
        for (int i = 0; i < numNTs; ++i) {
            this.left[i] = BitSet.make(numNTs);
            BitSet.set(this.left[i], i);
        }
        this.bottomUp();
    }

    @Override
    public boolean isAt(int i) {
        return false;
    }

    @Override
    protected boolean analyze(int i) {
        Grammar.Prod[] aprod;
        boolean flag = false;
        for (Grammar.Prod anAprod : aprod = this.grammar.getProds(i)) {
            int[] ai = anAprod.getRhs();
            if (ai.length <= 0 || !this.grammar.isNonterminal(ai[0]) || !BitSet.addTo(this.left[i], this.left[ai[0]])) continue;
            flag = true;
        }
        return flag;
    }

    public int[] at(int i) {
        return this.left[i];
    }

    public void display(Writer writer) throws IOException {
        writer.write("Left nonterminal sets:\n");
        for (int i = 0; i < this.left.length; ++i) {
            writer.write(" Left(" + this.grammar.getSymbol(i) + "): {");
            writer.write(this.grammar.displaySymbolSet(this.left[i], 0));
            writer.write("}\n");
        }
    }
}

