/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jacc.grammar;

import java.io.IOException;
import java.io.Writer;
import org.xbib.jacc.grammar.Grammar;
import org.xbib.jacc.grammar.LR0Items;
import org.xbib.jacc.grammar.Left;
import org.xbib.jacc.util.BitSet;
import org.xbib.jacc.util.IntSet;
import org.xbib.jacc.util.Interator;

public class Machine {
    private final IntSet acceptItems = IntSet.singleton(-1);
    protected Grammar grammar;
    protected int numNTs;
    protected int numTs;
    protected Left left;
    LR0Items items;
    int numStates;
    int[] entry;
    int[][] succState;
    private int numSyms;
    private IntSet[] stateSets;
    private IntSet[] nullReds;
    private int[][] gotos;
    private int[][] shifts;
    private int[][] reduceOffsets;

    Machine(Grammar grammar) {
        this.grammar = grammar;
        this.numSyms = grammar.getNumSyms();
        this.numNTs = grammar.getNumNTs();
        this.numTs = grammar.getNumTs();
        this.left = grammar.getLeft();
        this.items = new LR0Items(grammar);
        this.calcLR0states();
        this.calcGotosShifts();
        this.calcReduceOffsets();
    }

    public Grammar getGrammar() {
        return this.grammar;
    }

    public int getNumStates() {
        return this.numStates;
    }

    public LR0Items getItems() {
        return this.items;
    }

    public LR0Items.Item reduceItem(int i, int j) {
        return this.items.getItem(this.stateSets[i].at(j));
    }

    public int getEntry(int i) {
        return i >= 0 ? this.entry[i] : this.numSyms - 1;
    }

    public IntSet getItemsAt(int i) {
        return this.stateSets[i];
    }

    public int[] getGotosAt(int i) {
        return this.gotos[i];
    }

    public int[] getShiftsAt(int i) {
        return this.shifts[i];
    }

    int[] getReducesAt(int i) {
        return this.reduceOffsets[i];
    }

    private void calcLR0states() {
        this.stateSets = new IntSet[16];
        this.succState = new int[16][];
        this.entry = new int[16];
        this.nullReds = new IntSet[16];
        this.stateSets[0] = IntSet.singleton(this.items.getStartItem());
        this.numStates = 1;
        IntSet[] aintset = new IntSet[this.numSyms];
        int i = 0;
        int[] ai = BitSet.make(this.numNTs);
        for (int j = 0; j < this.numStates; ++j) {
            IntSet intset = this.stateSets[j];
            BitSet.clear(ai);
            Interator interator = intset.interator();
            while (interator.hasNext()) {
                LR0Items.Item item = this.items.getItem(interator.next());
                if (!item.canGoto()) continue;
                int k = item.getNextSym();
                int i1 = item.getNextItem();
                if (this.grammar.isNonterminal(k)) {
                    BitSet.addTo(ai, this.left.at(k));
                }
                if (!this.addValue(aintset, k, i1)) continue;
                ++i;
            }
            if (!BitSet.isEmpty(ai)) {
                Interator interator1 = BitSet.interator(ai, 0);
                while (interator1.hasNext()) {
                    int l = interator1.next();
                    Grammar.Prod[] aprod = this.grammar.getProds(l);
                    for (int k1 = 0; k1 < aprod.length; ++k1) {
                        int[] ai3 = aprod[k1].getRhs();
                        int i2 = this.items.getFirstKernel(l, k1);
                        if (ai3.length != 0) {
                            if (!this.addValue(aintset, ai3[0], i2)) continue;
                            ++i;
                            continue;
                        }
                        this.addValue(this.nullReds, j, i2);
                    }
                }
            }
            int[] ai1 = new int[i];
            int j1 = 0;
            int l1 = 0;
            while (j1 < i) {
                if (aintset[l1] != null) {
                    ai1[j1] = this.addState(l1, aintset[l1]);
                    aintset[l1] = null;
                    ++j1;
                }
                ++l1;
            }
            i = 0;
            this.succState[j] = ai1;
        }
        this.mergeNullReds();
    }

    private boolean addValue(IntSet[] aintset, int i, int j) {
        if (aintset[i] == null) {
            aintset[i] = IntSet.singleton(j);
            return true;
        }
        aintset[i].add(j);
        return false;
    }

    private int addState(int i, IntSet intset) {
        for (int j = 0; j < this.numStates; ++j) {
            if (!this.stateSets[j].equals(intset)) continue;
            return j;
        }
        if (this.acceptItems.equals(intset)) {
            return -1;
        }
        if (this.numStates >= this.stateSets.length) {
            int k = 2 * this.stateSets.length;
            IntSet[] aintset = new IntSet[k];
            int[][] ai = new int[k][];
            IntSet[] aintset1 = new IntSet[k];
            int[] ai1 = new int[k];
            for (int l = 0; l < this.numStates; ++l) {
                aintset[l] = this.stateSets[l];
                ai[l] = this.succState[l];
                ai1[l] = this.entry[l];
                aintset1[l] = this.nullReds[l];
            }
            this.stateSets = aintset;
            this.succState = ai;
            this.entry = ai1;
            this.nullReds = aintset1;
        }
        this.stateSets[this.numStates] = intset;
        this.entry[this.numStates] = i;
        return this.numStates++;
    }

    private void mergeNullReds() {
        for (int i = 0; i < this.numStates; ++i) {
            if (this.nullReds[i] == null) continue;
            Interator interator = this.nullReds[i].interator();
            while (interator.hasNext()) {
                this.stateSets[i].add(interator.next());
            }
            this.nullReds[i] = null;
        }
    }

    private void calcGotosShifts() {
        this.gotos = new int[this.numStates][];
        this.shifts = new int[this.numStates][];
        for (int i = 0; i < this.numStates; ++i) {
            int j = 0;
            int k = 0;
            for (int l = 0; l < this.succState[i].length; ++l) {
                int j1 = this.succState[i][l];
                if (this.grammar.isTerminal(this.entry[j1])) {
                    ++k;
                    continue;
                }
                ++j;
            }
            if (this.stateSets[i].contains(this.items.getEndItem())) {
                ++k;
            }
            this.gotos[i] = new int[j];
            this.shifts[i] = new int[k];
            int i1 = this.succState[i].length;
            while (0 < i1--) {
                int k1 = this.succState[i][i1];
                if (this.grammar.isTerminal(this.entry[k1])) {
                    this.shifts[i][--k] = k1;
                    continue;
                }
                this.gotos[i][--j] = k1;
            }
            if (k <= 0) continue;
            this.shifts[i][0] = -1;
        }
    }

    private void calcReduceOffsets() {
        this.reduceOffsets = new int[this.numStates][];
        for (int i = 0; i < this.numStates; ++i) {
            int j = 0;
            IntSet intset = this.stateSets[i];
            int k = intset.size();
            for (int l = 0; l < k; ++l) {
                if (!this.items.getItem(intset.at(l)).canReduce()) continue;
                ++j;
            }
            this.reduceOffsets[i] = new int[j];
            int i1 = 0;
            for (int j1 = 0; j1 < k; ++j1) {
                if (!this.items.getItem(intset.at(j1)).canReduce()) continue;
                this.reduceOffsets[i][i1++] = j1;
            }
        }
    }

    public void display(Writer writer) throws IOException {
        for (int i = 0; i < this.numStates; ++i) {
            writer.write("state " + i + "\n");
            Interator interator = this.stateSets[i].interator();
            while (interator.hasNext()) {
                writer.write("\t");
                this.items.getItem(interator.next()).display(writer);
                writer.write("\n");
            }
            writer.write("\n");
            if (this.succState[i].length <= 0) continue;
            for (int j = 0; j < this.succState[i].length; ++j) {
                int k = this.succState[i][j];
                writer.write("\t" + this.grammar.getSymbol(this.entry[k]) + " goto " + this.succState[i][j] + "\n");
            }
            writer.write("\n");
        }
    }
}

