/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jacc.grammar;

import java.io.IOException;
import java.io.Writer;
import org.xbib.jacc.grammar.Grammar;
import org.xbib.jacc.grammar.LR0Items;
import org.xbib.jacc.grammar.Machine;
import org.xbib.jacc.grammar.Tables;

public class Parser {
    private static final int ACCEPT = 0;
    private static final int ERROR = 1;
    private static final int SHIFT = 2;
    private static final int GOTO = 3;
    private static final int REDUCE = 4;
    private Tables tables;
    private int[] input;
    private Machine machine;
    private Grammar grammar;
    private int position = 0;
    private int currSymbol = -1;
    private int reducedNT = -1;
    private Stack stack = new Stack();
    private int state = 0;

    public Parser(Tables tables, int[] ai) {
        this.tables = tables;
        this.input = ai;
        this.machine = tables.getMachine();
        this.grammar = this.machine.getGrammar();
    }

    public int getState() {
        return this.state;
    }

    public int getNextSymbol() {
        return this.reducedNT < 0 ? this.currSymbol : this.reducedNT;
    }

    public int step() {
        if (this.state < 0) {
            return 0;
        }
        if (this.reducedNT >= 0) {
            this.shift(this.reducedNT);
            if (!this.gotoState(this.reducedNT)) {
                return 1;
            }
            this.reducedNT = -1;
            return 3;
        }
        if (this.currSymbol < 0) {
            int n = this.currSymbol = this.position < this.input.length ? this.input[this.position++] : this.grammar.getNumSyms() - 1;
        }
        if (this.grammar.isNonterminal(this.currSymbol)) {
            this.shift(this.currSymbol);
            if (!this.gotoState(this.currSymbol)) {
                return 1;
            }
            this.currSymbol = -1;
            return 3;
        }
        byte[] b = this.tables.getActionAt(this.state);
        int[] ai = this.tables.getArgAt(this.state);
        int i = this.currSymbol - this.grammar.getNumNTs();
        switch (b[i]) {
            case 1: {
                if (ai[i] < 0) {
                    return 0;
                }
                this.shift(this.currSymbol);
                this.currSymbol = -1;
                this.state = ai[i];
                return 2;
            }
            case 2: {
                this.reduce(ai[i]);
                return 4;
            }
        }
        return 1;
    }

    private void shift(int i) {
        this.stack = this.stack.push(this.state, i);
    }

    private void reduce(int i) {
        LR0Items.Item item = this.machine.reduceItem(this.state, i);
        int j = item.getProd().getRhs().length;
        if (j > 0) {
            while (j > 1) {
                this.stack = this.stack.pop();
                --j;
            }
            this.state = this.stack.getState();
            this.stack = this.stack.pop();
        }
        this.reducedNT = item.getLhs();
    }

    private boolean gotoState(int i) {
        int[] ai;
        for (int anAi : ai = this.machine.getGotosAt(this.state)) {
            if (i != this.machine.getEntry(anAi)) continue;
            this.state = anAi;
            return true;
        }
        return false;
    }

    public void display(Writer writer, boolean flag) throws IOException {
        this.stack.display(writer, this.grammar, flag);
        if (flag) {
            writer.write(this.state);
            writer.write(" ");
        }
        writer.write("_");
        if (this.reducedNT >= 0) {
            writer.write(" ");
            writer.write(this.grammar.getSymbol(this.reducedNT).toString());
            writer.write(" ");
        }
        if (this.currSymbol >= 0) {
            writer.write(" ");
            writer.write(this.grammar.getSymbol(this.currSymbol).toString());
            if (this.position < this.input.length) {
                writer.write(" ...");
            }
        } else if (this.position < this.input.length) {
            writer.write(" ");
            writer.write(this.grammar.getSymbol(this.input[this.position]).toString());
            writer.write(" ...");
        }
        writer.write("\n");
    }

    private static class Stack {
        private int state;
        private int symbol;
        private Stack up;
        private Stack down;

        Stack() {
            this(null);
        }

        private Stack(Stack stack) {
            this.down = stack;
            this.up = null;
        }

        int getState() {
            return this.state;
        }

        public int getSymbol() {
            return this.symbol;
        }

        Stack pop() {
            return this.down;
        }

        Stack push(int i, int j) {
            Stack stack1 = this.up;
            if (stack1 == null) {
                stack1 = this.up = new Stack(this);
            }
            stack1.state = i;
            stack1.symbol = j;
            return stack1;
        }

        public void display(Writer writer, Grammar grammar1, boolean flag) throws IOException {
            if (this.down != null) {
                this.down.display(writer, grammar1, flag);
                if (flag) {
                    writer.write(this.state);
                    writer.write(" ");
                }
                writer.write(grammar1.getSymbol(this.symbol).toString());
                writer.write(" ");
            }
        }
    }
}

