/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jacc.grammar;

import java.io.IOException;
import java.io.Writer;
import org.xbib.jacc.grammar.Follow;
import org.xbib.jacc.grammar.Grammar;
import org.xbib.jacc.grammar.LookaheadMachine;
import org.xbib.jacc.util.IntSet;

public class SLRMachine
extends LookaheadMachine {
    private Follow follow;
    private int[][][] laReds;

    public SLRMachine(Grammar grammar) {
        super(grammar);
        this.follow = grammar.getFollow();
        this.calcLookahead();
    }

    @Override
    public int[] getLookaheadAt(int i, int j) {
        return this.laReds[i][j];
    }

    private void calcLookahead() {
        this.laReds = new int[this.numStates][][];
        for (int i = 0; i < this.numStates; ++i) {
            IntSet intset = this.getItemsAt(i);
            int[] ai = this.getReducesAt(i);
            this.laReds[i] = new int[ai.length][];
            for (int j = 0; j < ai.length; ++j) {
                int k = this.items.getItem(intset.at(ai[j])).getLhs();
                this.laReds[i][j] = this.follow.at(k);
            }
        }
    }

    @Override
    public void display(Writer writer) throws IOException {
        super.display(writer);
        for (int i = 0; i < this.numStates; ++i) {
            IntSet intset = this.getItemsAt(i);
            int[] ai = this.getReducesAt(i);
            if (ai.length <= 0) continue;
            writer.write("In state " + i + ":");
            for (int j = 0; j < ai.length; ++j) {
                writer.write(" Item: ");
                this.items.getItem(intset.at(ai[j])).display(writer);
                writer.write("\n");
                writer.write("  Lookahead: {");
                writer.write(this.grammar.displaySymbolSet(this.laReds[i][j], this.numNTs));
                writer.write("}\n");
            }
        }
    }
}

