/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jacc;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.jacc.Fixity;
import org.xbib.jacc.JaccException;
import org.xbib.jacc.JaccJob;
import org.xbib.jacc.JaccLexer;
import org.xbib.jacc.JaccProd;
import org.xbib.jacc.JaccSettings;
import org.xbib.jacc.JaccSymbol;
import org.xbib.jacc.JaccTokens;
import org.xbib.jacc.NamedJaccSymbols;
import org.xbib.jacc.NumJaccSymbols;
import org.xbib.jacc.compiler.Failure;
import org.xbib.jacc.compiler.Handler;
import org.xbib.jacc.compiler.Phase;
import org.xbib.jacc.compiler.Position;
import org.xbib.jacc.compiler.Warning;
import org.xbib.jacc.grammar.Grammar;

class JaccParser
extends Phase
implements JaccTokens {
    private static final Logger logger = Logger.getLogger(JaccParser.class.getName());
    private final JaccSettings jaccSettings;
    private final NamedJaccSymbols terminals;
    private final NamedJaccSymbols nonterms;
    private final NumJaccSymbols literals;
    private int seqNo;
    private JaccLexer lexer;
    private int precedence;
    private JaccSymbol startSymbol;

    JaccParser(Handler handler, JaccSettings jaccSettings) {
        super(handler);
        this.jaccSettings = jaccSettings;
        this.terminals = new NamedJaccSymbols();
        this.nonterms = new NamedJaccSymbols();
        this.literals = new NumJaccSymbols();
        this.seqNo = 1;
        this.precedence = 0;
        this.startSymbol = null;
    }

    public Grammar getGrammar() {
        try {
            int i = this.nonterms.getSize();
            int j = this.terminals.getSize() + this.literals.getSize() + 1;
            if (i == 0 || this.startSymbol == null) {
                this.report(new Failure("No nonterminals defined"));
                return null;
            }
            Grammar.Symbol[] ajaccsymbol = new JaccSymbol[i + j];
            this.literals.fill((JaccSymbol[])ajaccsymbol, this.terminals.fill((JaccSymbol[])ajaccsymbol, this.nonterms.fill((JaccSymbol[])ajaccsymbol, 0)));
            ajaccsymbol[i + j - 1] = new JaccSymbol("$end");
            ajaccsymbol[i + j - 1].setNum(0);
            int k = 1;
            for (int l = 0; l < j - 1; ++l) {
                if (ajaccsymbol[i + l].getNum() >= 0) continue;
                while (this.literals.find(k) != null) {
                    ++k;
                }
                ajaccsymbol[i + l].setNum(k++);
            }
            for (int i1 = 0; i1 < i; ++i1) {
                if (ajaccsymbol[i1] != this.startSymbol) continue;
                if (i1 <= 0) break;
                JaccSymbol jaccsymbol = ajaccsymbol[0];
                ajaccsymbol[0] = ajaccsymbol[i1];
                ajaccsymbol[i1] = jaccsymbol;
                break;
            }
            for (int j1 = 0; j1 < ajaccsymbol.length; ++j1) {
                ajaccsymbol[j1].setTokenNo(j1);
            }
            Grammar.Prod[][] ajaccprod = new JaccProd[this.nonterms.getSize()][];
            for (int k1 = 0; k1 < ajaccprod.length; ++k1) {
                ajaccprod[k1] = ajaccsymbol[k1].getProds();
                if (ajaccprod[k1] != null && ajaccprod[k1].length != 0) continue;
                this.report(new Failure("No productions for " + ajaccsymbol[k1].getName()));
            }
            return new Grammar(ajaccsymbol, ajaccprod);
        }
        catch (JaccException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            this.report(new Failure("Internal problem " + e.getMessage()));
            return null;
        }
    }

    void parse(JaccLexer jacclexer) throws IOException {
        this.lexer = jacclexer;
        this.terminals.findOrAdd("error");
        this.parseDefinitions();
        if (jacclexer.getToken() != 1) {
            this.report(new Failure(jacclexer.getPos(), "Missing grammar"));
        } else {
            jacclexer.nextToken();
            this.parseGrammar();
            if (jacclexer.getToken() == 1) {
                String s;
                while ((s = jacclexer.readWholeLine()) != null) {
                    this.jaccSettings.addPostText(s);
                    this.jaccSettings.addPostText("\n");
                }
            }
        }
        jacclexer.close();
    }

    int[] parseSymbols(JaccLexer jacclexer) throws IOException {
        this.lexer = jacclexer;
        SymList symlist = null;
        while (true) {
            JaccSymbol jaccsymbol;
            if ((jaccsymbol = this.parseDefinedSymbol()) == null) {
                if (jacclexer.getToken() != 0) {
                    this.report(new Warning(jacclexer.getPos(), "Ignoring extra tokens at end of input"));
                }
                jacclexer.close();
                return SymList.toIntArray(symlist);
            }
            symlist = new SymList(jaccsymbol, symlist);
            jacclexer.nextToken();
        }
    }

    void parseErrorExamples(JaccLexer jacclexer, JaccJob jaccjob) throws IOException {
        this.lexer = jacclexer;
        while (jacclexer.getToken() == 5) {
            int i;
            String s = jacclexer.getLexeme();
            if (jacclexer.nextToken() == 58) {
                jacclexer.nextToken();
            } else {
                this.report(new Warning(jacclexer.getPos(), "A colon was expected here"));
            }
            while (true) {
                JaccSymbol jaccsymbol;
                Position position = jacclexer.getPos();
                SymList symlist = null;
                while ((jaccsymbol = this.parseDefinedSymbol()) != null) {
                    symlist = new SymList(jaccsymbol, symlist);
                    jacclexer.nextToken();
                }
                int[] ai = SymList.toIntArray(symlist);
                jaccjob.errorExample(position, s, ai);
                i = jacclexer.getToken();
                if (i != 124) break;
                jacclexer.nextToken();
            }
            if (i == 0) continue;
            if (i != 59) {
                this.report(new Failure(jacclexer.getPos(), "Unexpected token; a semicolon was expected here"));
                while ((i = jacclexer.nextToken()) != 59 && i != 0) {
                }
            }
            if (i != 59) continue;
            jacclexer.nextToken();
        }
        if (jacclexer.getToken() != 0) {
            this.report(new Failure(jacclexer.getPos(), "Unexpected token; ignoring the rest of this file"));
        }
        jacclexer.close();
    }

    private void parseDefinitions() throws IOException {
        boolean flag = false;
        while (true) {
            switch (this.lexer.getToken()) {
                case 0: 
                case 1: {
                    return;
                }
            }
            if (this.parseDefinition()) {
                flag = false;
                continue;
            }
            if (!flag) {
                flag = true;
                this.report(new Failure(this.lexer.getPos(), "Syntax error in definition"));
            }
            this.lexer.nextToken();
        }
    }

    private boolean parseDefinition() throws IOException {
        switch (this.lexer.getToken()) {
            case 2: {
                this.jaccSettings.addPreText(this.lexer.getLexeme());
                this.lexer.nextToken();
                return true;
            }
            case 8: {
                this.parseTokenDefn();
                return true;
            }
            case 9: {
                this.parseTypeDefn();
                return true;
            }
            case 11: {
                this.parseFixityDefn(Fixity.left(this.precedence++));
                return true;
            }
            case 13: {
                this.parseFixityDefn(Fixity.nonass(this.precedence++));
                return true;
            }
            case 12: {
                this.parseFixityDefn(Fixity.right(this.precedence++));
                return true;
            }
            case 14: {
                this.parseStart();
                return true;
            }
            case 16: {
                this.jaccSettings.setClassName(this.parseIdent(this.lexer.getLexeme(), this.jaccSettings.getClassName()));
                return true;
            }
            case 17: {
                this.jaccSettings.setInterfaceName(this.parseIdent(this.lexer.getLexeme(), this.jaccSettings.getInterfaceName()));
                return true;
            }
            case 15: {
                this.jaccSettings.setPackageName(this.parseDefnQualName(this.lexer.getLexeme(), this.jaccSettings.getPackageName()));
                return true;
            }
            case 18: {
                this.jaccSettings.setExtendsName(this.parseDefnQualName(this.lexer.getLexeme(), this.jaccSettings.getExtendsName()));
                return true;
            }
            case 19: {
                this.lexer.nextToken();
                String s = this.parseQualName();
                if (s != null) {
                    this.jaccSettings.addImplementsNames(s);
                }
                return true;
            }
            case 20: {
                this.jaccSettings.setTypeName(this.parseDefnQualName(this.lexer.getLexeme(), this.jaccSettings.getTypeName()));
                if (this.lexer.getToken() == 58) {
                    this.jaccSettings.setGetSemantic(this.lexer.readCodeLine());
                    this.lexer.nextToken();
                }
                return true;
            }
            case 21: {
                this.jaccSettings.setGetToken(this.lexer.readCodeLine());
                this.lexer.nextToken();
                return true;
            }
            case 22: {
                this.jaccSettings.setNextToken(this.lexer.readCodeLine());
                this.lexer.nextToken();
                return true;
            }
        }
        return false;
    }

    private void parseStart() throws IOException {
        Position position = this.lexer.getPos();
        this.lexer.nextToken();
        JaccSymbol jaccsymbol = this.parseNonterminal();
        if (jaccsymbol == null) {
            this.report(new Failure(position, "Missing start symbol"));
        } else {
            if (this.startSymbol == null) {
                this.startSymbol = jaccsymbol;
            } else {
                this.report(new Failure(position, "Multiple %start definitions are not permitted"));
            }
            this.lexer.nextToken();
        }
    }

    private String parseIdent(String s, String s1) throws IOException {
        Position position = this.lexer.getPos();
        if (this.lexer.nextToken() != 3) {
            this.report(new Failure(this.lexer.getPos(), "Syntax error in %" + s + " directive; identifier expected"));
            return s1;
        }
        String s2 = this.lexer.getLexeme();
        this.lexer.nextToken();
        if (s2 != null && s1 != null) {
            this.report(new Failure(position, "Multiple %" + s + " definitions are not permitted"));
            s2 = s1;
        }
        return s2;
    }

    private String parseDefnQualName(String s, String s1) throws IOException {
        Position position = this.lexer.getPos();
        this.lexer.nextToken();
        String s2 = this.parseQualName();
        if (s2 != null && s1 != null) {
            this.report(new Failure(position, "Multiple %" + s + " definitions are not permitted"));
            s2 = s1;
        }
        return s2;
    }

    private void parseTokenDefn() throws IOException {
        Position position = this.lexer.getPos();
        String s = this.optionalType();
        int i = 0;
        while (true) {
            JaccSymbol jaccsymbol;
            if ((jaccsymbol = this.parseTerminal()) == null) {
                if (i == 0) {
                    this.report(new Failure(position, "Missing symbols in %token definition"));
                }
                return;
            }
            this.addType(jaccsymbol, s);
            this.lexer.nextToken();
            ++i;
        }
    }

    private void parseTypeDefn() throws IOException {
        Position position = this.lexer.getPos();
        String s = this.optionalType();
        int i = 0;
        while (true) {
            JaccSymbol jaccsymbol;
            if ((jaccsymbol = this.parseSymbol()) == null) {
                if (i == 0) {
                    this.report(new Failure(position, "Missing symbols in %type definition"));
                }
                return;
            }
            this.addType(jaccsymbol, s);
            this.lexer.nextToken();
            ++i;
        }
    }

    private void parseFixityDefn(Fixity fixity) throws IOException {
        Position position = this.lexer.getPos();
        String s = this.optionalType();
        int i = 0;
        while (true) {
            JaccSymbol jaccsymbol;
            if ((jaccsymbol = this.parseTerminal()) == null) {
                if (i == 0) {
                    this.report(new Failure(position, "Missing symbols in fixity definition"));
                }
                return;
            }
            this.addFixity(jaccsymbol, fixity);
            this.addType(jaccsymbol, s);
            this.lexer.nextToken();
            ++i;
        }
    }

    private String optionalType() throws IOException {
        StringBuilder sb = new StringBuilder();
        if (this.lexer.nextToken() == 60) {
            this.lexer.nextToken();
            sb.append(this.parseQualName());
            while (this.lexer.getToken() == 91) {
                if (this.lexer.nextToken() == 93) {
                    this.lexer.nextToken();
                    sb.append("[]");
                    continue;
                }
                this.report(new Failure(this.lexer.getPos(), "Missing ']' in array type"));
                break;
            }
            if (this.lexer.getToken() == 62) {
                this.lexer.nextToken();
            } else if (sb.length() > 0) {
                this.report(new Failure(this.lexer.getPos(), "Missing `>' in type specification"));
            }
            return sb.toString();
        }
        return null;
    }

    private void addFixity(JaccSymbol jaccsymbol, Fixity fixity) {
        if (!jaccsymbol.setFixity(fixity)) {
            this.report(new Warning(this.lexer.getPos(), "Cannot change fixity for " + jaccsymbol.getName()));
        }
    }

    private void addType(JaccSymbol jaccsymbol, String s) {
        if (s != null && !jaccsymbol.setType(s)) {
            this.report(new Warning(this.lexer.getPos(), "Cannot change type for " + jaccsymbol.getName()));
        }
    }

    private void parseGrammar() throws IOException {
        JaccSymbol jaccsymbol;
        while ((jaccsymbol = this.parseLhs()) != null) {
            if (this.startSymbol == null) {
                this.startSymbol = jaccsymbol;
            }
            jaccsymbol.addProduction(this.parseRhs());
            while (this.lexer.getToken() == 124) {
                this.lexer.nextToken();
                jaccsymbol.addProduction(this.parseRhs());
            }
            if (this.lexer.getToken() == 59) {
                this.lexer.nextToken();
                continue;
            }
            this.report(new Warning(this.lexer.getPos(), "Missing ';' at end of rule"));
        }
    }

    private JaccSymbol parseLhs() throws IOException {
        boolean flag = false;
        int i = this.lexer.getToken();
        while (i != 1 && i != 0) {
            JaccSymbol jaccsymbol = this.parseNonterminal();
            if (jaccsymbol == null) {
                if (!flag) {
                    if (this.parseTerminal() != null) {
                        this.report(new Failure(this.lexer.getPos(), "Terminal symbol used on left hand side of rule"));
                    } else {
                        this.report(new Failure(this.lexer.getPos(), "Missing left hand side in rule"));
                    }
                    flag = true;
                }
                i = this.lexer.nextToken();
                continue;
            }
            i = this.lexer.nextToken();
            if (i != 58) {
                if (!flag) {
                    this.report(new Failure(this.lexer.getPos(), "Missing colon after left hand side of rule"));
                }
                flag = true;
                continue;
            }
            this.lexer.nextToken();
            return jaccsymbol;
        }
        return null;
    }

    private JaccProd parseRhs() throws IOException {
        Fixity fixity = null;
        SymList symlist = null;
        while (true) {
            if (this.lexer.getToken() == 10) {
                this.lexer.nextToken();
                JaccSymbol jaccsymbol = this.parseSymbol();
                if (jaccsymbol == null) {
                    this.report(new Failure(this.lexer.getPos(), "Missing token for %prec directive"));
                    continue;
                }
                if (jaccsymbol.getFixity() == null) {
                    this.report(new Failure(this.lexer.getPos(), "Ignoring %prec annotation because no fixity has been specified for " + jaccsymbol.getName()));
                    this.lexer.nextToken();
                    continue;
                }
                if (fixity != null) {
                    this.report(new Warning(this.lexer.getPos(), "Multiple %prec annotations in production"));
                }
                fixity = jaccsymbol.getFixity();
                this.lexer.nextToken();
                continue;
            }
            JaccSymbol jaccsymbol1 = this.parseSymbol();
            if (jaccsymbol1 == null) break;
            symlist = new SymList(jaccsymbol1, symlist);
            this.lexer.nextToken();
        }
        String s = null;
        Position position = null;
        if (this.lexer.getToken() == 7) {
            s = this.lexer.getLexeme();
            position = this.lexer.getPos();
            this.lexer.nextToken();
        }
        JaccSymbol[] ajaccsymbol = SymList.toArray(symlist);
        return new JaccProd(fixity, ajaccsymbol, position, s, this.seqNo++);
    }

    private String parseQualName() throws IOException {
        if (this.lexer.getToken() != 3) {
            this.report(new Failure(this.lexer.getPos(), "Syntax error in qualified name; identifier expected"));
            return null;
        }
        StringBuilder stringbuffer = new StringBuilder();
        while (true) {
            stringbuffer.append(this.lexer.getLexeme());
            if (this.lexer.nextToken() != 46) break;
            if (this.lexer.nextToken() != 3) {
                this.report(new Failure(this.lexer.getPos(), "Syntax error in qualified name"));
                break;
            }
            stringbuffer.append('.');
        }
        return stringbuffer.toString();
    }

    private JaccSymbol parseTerminal() {
        String s = this.lexer.getLexeme();
        switch (this.lexer.getToken()) {
            case 3: {
                if (this.nonterms.find(s) != null) {
                    return null;
                }
                return this.terminals.findOrAdd(s);
            }
            case 4: {
                return this.literals.findOrAdd(s, this.lexer.getLastLiteral());
            }
        }
        return null;
    }

    private JaccSymbol parseNonterminal() {
        String s = this.lexer.getLexeme();
        if (this.lexer.getToken() == 3) {
            if (this.terminals.find(s) != null) {
                return null;
            }
            return this.nonterms.findOrAdd(s);
        }
        return null;
    }

    private JaccSymbol parseSymbol() {
        String s = this.lexer.getLexeme();
        switch (this.lexer.getToken()) {
            case 3: {
                JaccSymbol jaccsymbol = this.terminals.find(s);
                if (jaccsymbol == null) {
                    jaccsymbol = this.nonterms.findOrAdd(s);
                }
                return jaccsymbol;
            }
            case 4: {
                return this.literals.findOrAdd(s, this.lexer.getLastLiteral());
            }
        }
        return null;
    }

    private JaccSymbol parseDefinedSymbol() {
        String s = this.lexer.getLexeme();
        switch (this.lexer.getToken()) {
            case 3: {
                JaccSymbol jaccsymbol = this.nonterms.find(s);
                return jaccsymbol == null ? this.terminals.find(s) : jaccsymbol;
            }
            case 4: {
                return this.literals.find(this.lexer.getLastLiteral());
            }
        }
        return null;
    }

    private static class SymList {
        JaccSymbol head;
        SymList tail;

        SymList(JaccSymbol jaccsymbol, SymList symlist) {
            this.head = jaccsymbol;
            this.tail = symlist;
        }

        static int length(SymList list) {
            SymList symlist = list;
            int i = 0;
            while (symlist != null) {
                ++i;
                symlist = symlist.tail;
            }
            return i;
        }

        static JaccSymbol[] toArray(SymList list) {
            SymList symlist = list;
            int i = SymList.length(symlist);
            JaccSymbol[] ajaccsymbol = new JaccSymbol[i];
            while (i > 0) {
                ajaccsymbol[--i] = symlist.head;
                symlist = symlist.tail;
            }
            return ajaccsymbol;
        }

        static int[] toIntArray(SymList list) {
            SymList symlist = list;
            int i = SymList.length(symlist);
            int[] ai = new int[i];
            while (i > 0) {
                ai[--i] = symlist.head.getTokenNo();
                symlist = symlist.tail;
            }
            return ai;
        }
    }
}

