/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jacc;

import java.io.IOException;
import java.io.Writer;
import org.xbib.jacc.AbstractOutput;
import org.xbib.jacc.JaccJob;
import org.xbib.jacc.JaccProd;
import org.xbib.jacc.JaccSymbol;
import org.xbib.jacc.compiler.Failure;
import org.xbib.jacc.compiler.Handler;
import org.xbib.jacc.grammar.Grammar;

class ParserOutput
extends AbstractOutput {
    private int yyaccept;
    private int yyabort;
    private int stackOverflow;
    private int errorHandler;
    private int userErrorHandler;
    private int[] stNumSwitches;
    private int[][] ntGoto;
    private int[][] ntGotoSrc;
    private int[] ntDefault;
    private int[] ntDistinct;
    private int errTok;
    private boolean errMsgs = false;
    private boolean errUsed = false;

    ParserOutput(Handler handler, JaccJob jaccjob) {
        super(handler, jaccjob);
        this.tables.analyzeRows();
    }

    @Override
    public void write(Writer writer) throws IOException {
        ParserOutput.datestamp(writer);
        String s = this.jaccSettings.getPackageName();
        if (s != null) {
            writer.write("package " + s + ";\n");
        }
        if (this.jaccSettings.getPreText() != null) {
            writer.write(this.jaccSettings.getPreText() + "\n");
        }
        this.yyaccept = 2 * this.numStates;
        this.stackOverflow = 2 * this.numStates + 1;
        this.yyabort = 2 * this.numStates + 2;
        this.errorHandler = 2 * this.numStates + 3;
        this.userErrorHandler = 2 * this.numStates + 4;
        int[] ai = new int[this.numNTs];
        this.stNumSwitches = new int[this.numStates];
        for (int i = 0; i < this.numStates; ++i) {
            int n;
            int[] ai1;
            int[] nArray = ai1 = this.machine.getGotosAt(i);
            int n2 = nArray.length;
            for (int j = 0; j < n2; ++j) {
                n = nArray[j];
                int n3 = this.machine.getEntry(n);
                ai[n3] = ai[n3] + 1;
            }
            byte[] nArray2 = this.tables.getActionAt(i);
            int[] ai4 = this.tables.getArgAt(i);
            int l3 = this.tables.getDefaultRowAt(i);
            this.stNumSwitches[i] = 0;
            for (n = 0; n < nArray2.length; ++n) {
                if (l3 >= 0 && nArray2[n] == nArray2[l3] && ai4[n] == ai4[l3]) continue;
                int n4 = i;
                this.stNumSwitches[n4] = this.stNumSwitches[n4] + 1;
            }
        }
        this.ntGoto = new int[this.numNTs][];
        this.ntGotoSrc = new int[this.numNTs][];
        this.ntDefault = new int[this.numNTs];
        this.ntDistinct = new int[this.numNTs];
        for (int j = 0; j < this.numNTs; ++j) {
            this.ntGoto[j] = new int[ai[j]];
            this.ntGotoSrc[j] = new int[ai[j]];
        }
        for (int k = 0; k < this.numStates; ++k) {
            int[] ai2;
            for (int n : ai2 = this.machine.getGotosAt(k)) {
                int j3;
                int n5 = j3 = this.machine.getEntry(n);
                int n6 = ai[n5] - 1;
                ai[n5] = n6;
                this.ntGoto[j3][n6] = n;
                this.ntGotoSrc[j3][ai[j3]] = k;
            }
        }
        for (int l = 0; l < this.numNTs; ++l) {
            int n;
            int l1 = -1;
            boolean bl = false;
            int k3 = this.ntGoto[l].length;
            int i4 = 0;
            while (i4 + n < k3) {
                int n7 = 1;
                for (int l4 = i4 + 1; l4 < k3; ++l4) {
                    if (this.ntGoto[l][l4] != this.ntGoto[l][i4]) continue;
                    ++n7;
                }
                if (n7 > n) {
                    n = n7;
                    l1 = i4;
                }
                ++i4;
            }
            this.ntDefault[l] = l1;
            this.ntDistinct[l] = this.ntGoto[l].length - (n - 1);
        }
        this.errMsgs = this.tables.getNumErrors() > 0;
        this.errTok = this.numNTs;
        while (this.errTok < this.numSyms && !"error".equals(this.grammar.getSymbol(this.errTok).getName())) {
            ++this.errTok;
        }
        if (this.errTok < this.numSyms) {
            for (int i1 = 0; i1 < this.numStates && !this.errUsed; ++i1) {
                int[] ai3 = this.machine.getShiftsAt(i1);
                for (int i = 0; i < ai3.length && !this.errUsed; ++i) {
                    if (this.machine.getEntry(ai3[i]) != this.errTok) continue;
                    this.errUsed = true;
                }
            }
        }
        writer.write("public class " + this.jaccSettings.getClassName());
        if (this.jaccSettings.getExtendsName() != null) {
            writer.write(" extends " + this.jaccSettings.getExtendsName());
        }
        if (this.jaccSettings.getImplementsNames() != null) {
            writer.write(" implements " + this.jaccSettings.getImplementsNames());
        }
        writer.write(" {\n");
        ParserOutput.indent(writer, 1, new String[]{"private int yyss = 100;", "private int yytok;", "private int yysp = 0;", "private int[] yyst;", "protected int yyerrno = (-1);"});
        if (this.errUsed) {
            ParserOutput.indent(writer, 1, "private int yyerrstatus = 3;");
        }
        ParserOutput.indent(writer, 1, "private " + this.jaccSettings.getTypeName() + "[] yysv;");
        ParserOutput.indent(writer, 1, "private " + this.jaccSettings.getTypeName() + " yyrv;");
        writer.write("\n");
        this.defineParse(writer, 1);
        this.defineExpand(writer, 1);
        this.defineErrRec(writer, 1);
        for (int j1 = 0; j1 < this.numStates; ++j1) {
            this.defineState(writer, 1, j1);
        }
        for (int k1 = 0; k1 < this.numNTs; ++k1) {
            Grammar.Prod[] aprod;
            for (Grammar.Prod prod : aprod = this.grammar.getProds(k1)) {
                this.defineReduce(writer, 1, prod, k1);
            }
            this.defineNonterminal(writer, 1, k1);
        }
        this.defineErrMsgs(writer);
        if (this.jaccSettings.getPostText() != null) {
            writer.write(this.jaccSettings.getPostText() + "\n");
        }
        writer.write("}\n");
    }

    private void defineErrMsgs(Writer writer) throws IOException {
        if (this.errMsgs) {
            ParserOutput.indent(writer, 1, new String[]{"private int yyerr(int e, int n) {", "    yyerrno = e;", "    return n;", "}"});
        }
        ParserOutput.indent(writer, 1, "protected String[] yyerrmsgs = {");
        int i = this.tables.getNumErrors();
        if (i > 0) {
            for (int j = 0; j < i - 1; ++j) {
                ParserOutput.indent(writer, 2, "\"" + this.tables.getError(j) + "\",");
            }
            ParserOutput.indent(writer, 2, "\"" + this.tables.getError(i - 1) + "\"");
        }
        ParserOutput.indent(writer, 1, "};");
    }

    private void defineExpand(Writer writer, int i) throws IOException {
        ParserOutput.indent(writer, i, new String[]{"protected void yyexpand() {", "    int[] newyyst = new int[2*yyst.length];"});
        ParserOutput.indent(writer, i + 1, this.jaccSettings.getTypeName() + "[] newyysv = new " + this.jaccSettings.getTypeName() + "[2*yyst.length];");
        ParserOutput.indent(writer, i, new String[]{"    for (int i=0; i<yyst.length; i++) {", "        newyyst[i] = yyst[i];", "        newyysv[i] = yysv[i];", "    }", "    yyst = newyyst;", "    yysv = newyysv;", "}"});
        writer.write("\n");
    }

    private void defineErrRec(Writer writer, int i) throws IOException {
        if (this.errUsed) {
            ParserOutput.indent(writer, i, "public void yyerrok() {");
            ParserOutput.indent(writer, i + 1, "yyerrstatus = 3;");
            if (this.errMsgs) {
                ParserOutput.indent(writer, i + 1, "yyerrno     = (-1);");
            }
            ParserOutput.indent(writer, i, "}");
            writer.write("\n");
            ParserOutput.indent(writer, i, "public void yyclearin() {");
            ParserOutput.indent(writer, i + 1, "yytok = (" + this.jaccSettings.getNextToken());
            ParserOutput.indent(writer, i + 1, "        );");
            ParserOutput.indent(writer, i, "}");
            writer.write("\n");
        }
    }

    private void defineParse(Writer writer, int i) throws IOException {
        ParserOutput.indent(writer, i, "public boolean parse() {");
        ParserOutput.indent(writer, i + 1, new String[]{"int yyn = 0;", "yysp = 0;", "yyst = new int[yyss];"});
        if (this.errUsed) {
            ParserOutput.indent(writer, i + 1, "yyerrstatus = 3;");
        }
        if (this.errMsgs) {
            ParserOutput.indent(writer, i + 1, "yyerrno = (-1);");
        }
        ParserOutput.indent(writer, i + 1, "yysv = new " + this.jaccSettings.getTypeName() + "[yyss];");
        ParserOutput.indent(writer, i + 1, "yytok = (" + this.jaccSettings.getGetToken());
        ParserOutput.indent(writer, i + 1, "         );");
        ParserOutput.indent(writer, i, new String[]{"loop:", "    for (;;) {", "        switch (yyn) {"});
        for (int j = 0; j < this.numStates; ++j) {
            this.stateCases(writer, i + 3, j);
        }
        ParserOutput.indent(writer, i + 3, "case " + this.yyaccept + ":");
        ParserOutput.indent(writer, i + 4, "return true;");
        ParserOutput.indent(writer, i + 3, "case " + this.stackOverflow + ":");
        ParserOutput.indent(writer, i + 4, "yyerror(\"stack overflow\");");
        ParserOutput.indent(writer, i + 3, "case " + this.yyabort + ":");
        ParserOutput.indent(writer, i + 4, "return false;");
        this.errorCases(writer, i + 3);
        ParserOutput.indent(writer, i, new String[]{"        }", "    }", "}"});
        writer.write("\n");
    }

    private void stateCases(Writer writer, int i, int j) throws IOException {
        ParserOutput.indent(writer, i, "case " + j + ":");
        ParserOutput.indent(writer, i + 1, "yyst[yysp] = " + j + ";");
        if (this.grammar.isTerminal(this.machine.getEntry(j))) {
            ParserOutput.indent(writer, i + 1, "yysv[yysp] = (" + this.jaccSettings.getGetSemantic());
            ParserOutput.indent(writer, i + 1, "             );");
            ParserOutput.indent(writer, i + 1, "yytok = (" + this.jaccSettings.getNextToken());
            ParserOutput.indent(writer, i + 1, "        );");
            if (this.errUsed) {
                ParserOutput.indent(writer, i + 1, "yyerrstatus++;");
            }
        }
        ParserOutput.indent(writer, i + 1, new String[]{"if (++yysp>=yyst.length) {", "    yyexpand();", "}"});
        ParserOutput.indent(writer, i, "case " + (j + this.numStates) + ":");
        if (this.stNumSwitches[j] > 5) {
            this.continueTo(writer, i + 1, "yys" + j + "()", true);
        } else {
            this.switchState(writer, i + 1, j, true);
        }
        writer.write("\n");
    }

    private void continueTo(Writer writer, int i, String s, boolean flag) throws IOException {
        if (flag) {
            ParserOutput.indent(writer, i, "yyn = " + s + ";");
            ParserOutput.indent(writer, i, "continue;");
        } else {
            ParserOutput.indent(writer, i, "return " + s + ";");
        }
    }

    private void defineState(Writer writer, int i, int j) throws IOException {
        if (this.stNumSwitches[j] > 5) {
            ParserOutput.indent(writer, i, "private int yys" + j + "() {");
            this.switchState(writer, i + 1, j, false);
            ParserOutput.indent(writer, i, "}");
            writer.write("\n");
        }
    }

    private void switchState(Writer writer, int i, int j, boolean flag) throws IOException {
        byte[] abyte0 = this.tables.getActionAt(j);
        int[] ai = this.tables.getArgAt(j);
        int k = this.tables.getDefaultRowAt(j);
        if (this.stNumSwitches[j] > 0) {
            ParserOutput.indent(writer, i, "switch (yytok) {");
            int[] ai1 = this.tables.indexAt(j);
            int l = 0;
            while (l < ai1.length) {
                int i1 = ai1[l];
                byte byte0 = abyte0[i1];
                int j1 = ai[i1];
                int k1 = l;
                ++k1;
                while (k1 < ai1.length && abyte0[ai1[k1]] == byte0 && ai[ai1[k1]] == j1) {
                    ++k1;
                }
                if (k < 0 || byte0 != abyte0[k] || j1 != ai[k]) {
                    for (int l1 = l; l1 < k1; ++l1) {
                        ParserOutput.indent(writer, i + 1);
                        writer.write("case ");
                        if (ai1[l1] == this.numTs - 1) {
                            writer.write("ENDINPUT");
                        } else {
                            writer.write(this.grammar.getTerminal(ai1[l1]).getName());
                        }
                        writer.write(":\n");
                    }
                    this.continueTo(writer, i + 2, this.codeAction(j, byte0, j1), flag);
                }
                l = k1;
            }
            ParserOutput.indent(writer, i, "}");
        }
        if (k < 0) {
            this.continueTo(writer, i, Integer.toString(this.errorHandler), flag);
        } else {
            this.continueTo(writer, i, this.codeAction(j, abyte0[k], ai[k]), flag);
        }
    }

    private String codeAction(int i, int j, int k) {
        if (j == 0) {
            String s = Integer.toString(this.errorHandler);
            return k != 0 ? "yyerr(" + (k - 1) + ", " + s + ")" : s;
        }
        if (j == 2) {
            return "yyr" + this.machine.reduceItem(i, k).getSeqNo() + "()";
        }
        return Integer.toString(k >= 0 ? k : this.yyaccept);
    }

    private void defineReduce(Writer writer, int i, Grammar.Prod prod, int j) throws IOException {
        if (prod instanceof JaccProd && this.ntDefault[j] >= 0) {
            JaccProd jaccprod = (JaccProd)prod;
            ParserOutput.indent(writer, i);
            writer.write("private int yyr" + jaccprod.getSeqNo() + "() { // ");
            writer.write(this.grammar.getSymbol(j).getName() + " : ");
            writer.write(this.grammar.displaySymbols(jaccprod.getRhs(), "/* empty */", " ") + "\n");
            String s = jaccprod.getAction();
            int k = jaccprod.getRhs().length;
            if (s != null) {
                ParserOutput.indent(writer, i + 1);
                this.translateAction(writer, jaccprod, s);
                ParserOutput.indent(writer, i + 1, "yysv[yysp-=" + k + "] = yyrv;");
            } else if (k > 0) {
                ParserOutput.indent(writer, i + 1, "yysp -= " + k + ";");
            }
            this.gotoNonterminal(writer, i + 1, j);
            ParserOutput.indent(writer, i, "}");
            writer.write("\n");
        }
    }

    private void translateAction(Writer writer, JaccProd jaccprod, String s) throws IOException {
        int[] ai = jaccprod.getRhs();
        int i = s.length();
        for (int j = 0; j < i; ++j) {
            char c = s.charAt(j);
            if (c == '$') {
                c = s.charAt(j + 1);
                if (c == '$') {
                    ++j;
                    writer.write("yyrv");
                    continue;
                }
                if (Character.isDigit(c)) {
                    int k = 0;
                    do {
                        k = k * 10 + Character.digit(c, 10);
                    } while (Character.isDigit(c = s.charAt(++j + 1)));
                    if (k < 1 || k > ai.length) {
                        this.report(new Failure(jaccprod.getActionPos(), "$" + k + " cannot be used in this action."));
                        continue;
                    }
                    int l = 1 + ai.length - k;
                    String s1 = null;
                    if (this.grammar.getSymbol(ai[k - 1]) instanceof JaccSymbol) {
                        JaccSymbol jaccsymbol = (JaccSymbol)this.grammar.getSymbol(ai[k - 1]);
                        s1 = jaccsymbol.getType();
                    }
                    if (s1 != null) {
                        writer.write("((" + s1 + ")");
                    }
                    writer.write("yysv[yysp-" + l + "]");
                    if (s1 == null) continue;
                    writer.write(")");
                    continue;
                }
                writer.write(36);
                continue;
            }
            if (c == '\n') {
                writer.write("\n");
                continue;
            }
            writer.write(c);
        }
        writer.write("\n");
    }

    private void gotoNonterminal(Writer writer, int i, int j) throws IOException {
        if (this.ntDefault[j] < 0) {
            return;
        }
        if (this.ntDistinct[j] == 1) {
            ParserOutput.indent(writer, i, "return " + this.ntGoto[j][0] + ";");
        } else if (this.grammar.getProds(j).length == 1) {
            this.nonterminalSwitch(writer, i, j);
        } else {
            ParserOutput.indent(writer, i, "return " + this.ntName(j) + "();");
        }
    }

    private void defineNonterminal(Writer writer, int i, int j) throws IOException {
        if (this.ntDefault[j] >= 0 && this.ntDistinct[j] != 1 && this.grammar.getProds(j).length != 1) {
            ParserOutput.indent(writer, i, "private int " + this.ntName(j) + "() {");
            this.nonterminalSwitch(writer, i + 1, j);
            ParserOutput.indent(writer, i, "}");
            writer.write("\n");
        }
    }

    private void nonterminalSwitch(Writer writer, int i, int j) throws IOException {
        int k = this.ntGoto[j][this.ntDefault[j]];
        ParserOutput.indent(writer, i);
        writer.write("switch (yyst[yysp-1]) {\n");
        for (int l = 0; l < this.ntGoto[j].length; ++l) {
            int i1 = this.ntGoto[j][l];
            if (i1 == k) continue;
            ParserOutput.indent(writer, i + 1);
            writer.write("case " + this.ntGotoSrc[j][l]);
            writer.write(": return " + i1 + ";\n");
        }
        ParserOutput.indent(writer, i + 1);
        writer.write("default: return " + k + ";\n");
        ParserOutput.indent(writer, i);
        writer.write("}\n");
    }

    private String ntName(int i) {
        return "yyp" + this.grammar.getSymbol(i).getName();
    }

    private void errorCases(Writer writer, int i) throws IOException {
        ParserOutput.indent(writer, i, "case " + this.errorHandler + ":");
        if (!this.errUsed) {
            ParserOutput.indent(writer, i + 1, new String[]{"yyerror(\"syntax error\");", "return false;"});
            return;
        }
        ParserOutput.indent(writer, i + 1, new String[]{"if (yyerrstatus>2) {", "    yyerror(\"syntax error\");", "}"});
        ParserOutput.indent(writer, i, "case " + this.userErrorHandler + " :");
        ParserOutput.indent(writer, i + 1, new String[]{"if (yyerrstatus==0) {", "    if ((" + this.jaccSettings.getGetToken(), "         )==ENDINPUT) {", "        return false;", "    }", "    " + this.jaccSettings.getNextToken(), "    ;"});
        ParserOutput.indent(writer, i + 2, "yyn = " + this.numStates + " + yyst[yysp-1];");
        ParserOutput.indent(writer, i + 1, new String[]{"    continue;", "} else {", "    yyerrstatus = 0;", "    while (yysp>0) {", "        switch(yyst[yysp-1]) {"});
        for (int j = 0; j < this.numStates; ++j) {
            int[] ai;
            for (int anAi : ai = this.machine.getShiftsAt(j)) {
                if (this.machine.getEntry(anAi) != this.errTok) continue;
                ParserOutput.indent(writer, i + 4, "case " + j + ":");
                ParserOutput.indent(writer, i + 5, "yyn = " + anAi + ";");
                ParserOutput.indent(writer, i + 5, "continue loop;");
            }
        }
        ParserOutput.indent(writer, i + 1, new String[]{"        }", "        yysp--;", "    }", "    return false;", "}"});
    }
}

