/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jacc;

import java.io.IOException;
import java.io.Writer;
import org.xbib.jacc.AbstractOutput;
import org.xbib.jacc.JaccJob;
import org.xbib.jacc.compiler.Handler;
import org.xbib.jacc.util.IntSet;

class TextOutput
extends AbstractOutput {
    private boolean wantFirst = false;

    TextOutput(Handler handler, JaccJob jaccjob, boolean flag) {
        super(handler, jaccjob);
        this.wantFirst = flag;
        this.tables.analyzeRows();
    }

    @Override
    public void write(Writer writer) throws IOException {
        TextOutput.datestamp(writer);
        for (int i = 0; i < this.numStates; ++i) {
            writer.write(this.resolver.getConflictsAt(i));
            writer.write(this.describeEntry(i) + "\n");
            IntSet intset = this.machine.getItemsAt(i);
            int k = intset.size();
            for (int i1 = 0; i1 < k; ++i1) {
                TextOutput.indent(writer, 1);
                this.machine.getItems().getItem(intset.at(i1)).display(writer);
                writer.write("\n");
            }
            writer.write("\n");
            byte[] abyte0 = this.tables.getActionAt(i);
            int[] ai1 = this.tables.getArgAt(i);
            int j1 = this.tables.getDefaultRowAt(i);
            int[] ai2 = this.tables.indexAt(i);
            for (int k1 = 0; k1 < abyte0.length; ++k1) {
                int l1 = ai2[k1];
                if (j1 >= 0 && abyte0[l1] == abyte0[j1] && ai1[l1] == ai1[j1]) continue;
                TextOutput.indent(writer, 1);
                writer.write(this.grammar.getTerminal(l1).getName());
                writer.write(32);
                writer.write(this.describeAction(i, abyte0[l1], ai1[l1]) + "\n");
            }
            TextOutput.indent(writer, 1);
            if (j1 < 0) {
                writer.write(". error\n");
            } else {
                writer.write(". ");
                writer.write(this.describeAction(i, abyte0[j1], ai1[j1]) + "\n");
            }
            writer.write("\n");
            int[] ai3 = this.machine.getGotosAt(i);
            if (ai3.length <= 0) continue;
            for (int anAi3 : ai3) {
                int j2 = this.machine.getEntry(anAi3);
                TextOutput.indent(writer, 1);
                writer.write(this.grammar.getSymbol(j2).getName());
                writer.write(" " + this.describeGoto(anAi3) + "\n");
            }
            writer.write("\n");
        }
        if (this.wantFirst) {
            this.grammar.getFirst().display(writer);
            writer.write("\n");
            this.grammar.getFollow().display(writer);
            writer.write("\n");
            this.grammar.getNullable().display(writer);
            writer.write("\n");
        }
        if (this.tables.getProdUnused() > 0) {
            for (int j = 0; j < this.numNTs; ++j) {
                boolean[] aflag = this.tables.getProdsUsedAt(j);
                for (int l = 0; l < aflag.length; ++l) {
                    if (aflag[l]) continue;
                    int[] ai = this.grammar.getProds(j)[l].getRhs();
                    writer.write("Rule not reduced: ");
                    writer.write(this.grammar.getNonterminal(j).getName());
                    writer.write(" : ");
                    writer.write(this.grammar.displaySymbols(ai, "", " ") + "\n");
                }
            }
            writer.write("\n");
        }
        writer.write(this.numTs + " terminals, " + this.numNTs + " nonterminals;");
        writer.write(this.grammar.getNumProds() + " grammar rules, " + this.numStates + " states;");
        writer.write(this.resolver.getNumSRConflicts() + " shift/reduce and " + this.resolver.getNumRRConflicts() + " reduce/reduce conflicts reported.");
    }

    private String describeEntry(int i) {
        return "state " + i + " (entry on " + this.grammar.getSymbol(this.machine.getEntry(i)) + ")";
    }

    private String describeAction(int i, int j, int k) {
        if (j == 0) {
            if (k == 0) {
                return "error";
            }
            return "error \"" + this.tables.getError(k - 1) + "\"";
        }
        if (j == 2) {
            return "reduce " + this.machine.reduceItem(i, k).getSeqNo();
        }
        if (k < 0) {
            return "accept";
        }
        return this.describeShift(k);
    }

    private String describeShift(int i) {
        return "shift " + i;
    }

    private String describeGoto(int i) {
        return "goto " + i;
    }
}

