/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jacc;

import java.io.IOException;
import java.io.Writer;
import org.xbib.jacc.AbstractOutput;
import org.xbib.jacc.JaccJob;
import org.xbib.jacc.JaccSymbol;
import org.xbib.jacc.compiler.Handler;
import org.xbib.jacc.grammar.Grammar;

class TokensOutput
extends AbstractOutput {
    TokensOutput(Handler handler, JaccJob jaccjob) {
        super(handler, jaccjob);
    }

    @Override
    public void write(Writer writer) throws IOException {
        TokensOutput.datestamp(writer);
        String s = this.jaccSettings.getPackageName();
        if (s != null) {
            writer.write("package " + s + ";\n\n");
        }
        writer.write("interface " + this.jaccSettings.getInterfaceName() + " {\n");
        TokensOutput.indent(writer, 1);
        writer.write("int ENDINPUT = 0;\n");
        for (int i = 0; i < this.numTs - 1; ++i) {
            Grammar.Symbol symbol = this.grammar.getTerminal(i);
            if (!(symbol instanceof JaccSymbol)) continue;
            JaccSymbol jaccsymbol = (JaccSymbol)symbol;
            String s1 = jaccsymbol.getName();
            TokensOutput.indent(writer, 1);
            if (s1.startsWith("'")) {
                writer.write("// " + s1 + " (code=" + jaccsymbol.getNum() + ")\n");
                continue;
            }
            writer.write("int " + s1 + " = " + jaccsymbol.getNum() + ";\n");
        }
        writer.write("}\n");
    }
}

