/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jacc.compiler;

import java.io.IOException;
import java.io.Reader;
import org.xbib.jacc.compiler.Handler;
import org.xbib.jacc.compiler.Source;
import org.xbib.jacc.compiler.Warning;

public class JavaSource
extends Source {
    private final StringBuilder sb;
    private Reader input;
    private int tabwidth;
    private int c0;
    private int c1 = 0;
    private int lineNumber = 0;

    public JavaSource(Handler handler, Reader reader) {
        this(handler, reader, 8);
    }

    private JavaSource(Handler handler, Reader reader, int i) {
        super(handler);
        this.input = reader;
        this.tabwidth = i;
        this.sb = new StringBuilder();
    }

    private void skip() throws IOException {
        this.c0 = this.c1;
        if (this.c0 != -1) {
            this.c1 = this.input.read();
            if (this.c0 == 26 && this.c1 == -1) {
                this.c0 = this.c1;
            }
        }
    }

    @Override
    public String readLine() throws IOException {
        if (this.input == null) {
            return null;
        }
        this.sb.setLength(0);
        if (this.lineNumber++ == 0) {
            this.skip();
            this.skip();
        }
        if (this.c0 == -1) {
            return null;
        }
        while (this.c0 != -1 && this.c0 != 10 && this.c0 != 13) {
            if (this.c0 == 92) {
                this.skip();
                if (this.c0 == 117) {
                    int l;
                    int k;
                    do {
                        this.skip();
                    } while (this.c0 == 117);
                    int i = 0;
                    for (k = 0; k < 4 && this.c0 != -1 && (l = Character.digit((char)this.c0, 16)) >= 0; ++k) {
                        i = (i << 4) + l;
                        this.skip();
                    }
                    if (k != 4) {
                        this.report(new Warning("Error in Unicode escape sequence"));
                        continue;
                    }
                    this.sb.append((char)i);
                    continue;
                }
                this.sb.append('\\');
                if (this.c0 == -1) break;
                this.sb.append((char)this.c0);
                this.skip();
                continue;
            }
            if (this.c0 == 9 && this.tabwidth > 0) {
                for (int j = this.tabwidth - this.sb.length() % this.tabwidth; j > 0; --j) {
                    this.sb.append(' ');
                }
                this.skip();
                continue;
            }
            this.sb.append((char)this.c0);
            this.skip();
        }
        if (this.c0 == 13) {
            this.skip();
        }
        if (this.c0 == 10) {
            this.skip();
        }
        return this.sb.toString();
    }

    @Override
    public int getLineNo() {
        return this.lineNumber;
    }

    @Override
    public void close() throws IOException {
        if (this.input != null) {
            this.input.close();
            this.input = null;
            this.sb.setLength(0);
        }
    }
}

