/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jacc.grammar;

import java.io.IOException;
import java.io.Writer;
import org.xbib.jacc.grammar.Analysis;
import org.xbib.jacc.grammar.First;
import org.xbib.jacc.grammar.Grammar;
import org.xbib.jacc.grammar.Nullable;
import org.xbib.jacc.util.BitSet;

public class Follow
extends Analysis {
    private Grammar grammar;
    private Nullable nullable;
    private First first;
    private int numNTs;
    private int[][] follows;

    Follow(Grammar grammar, Nullable nullable, First first1) {
        super(grammar.getComponents());
        this.grammar = grammar;
        this.nullable = nullable;
        this.first = first1;
        this.numNTs = grammar.getNumNTs();
        int numTs = grammar.getNumTs();
        this.follows = new int[this.numNTs][];
        for (int i = 0; i < this.numNTs; ++i) {
            this.follows[i] = BitSet.make(numTs);
        }
        BitSet.set(this.follows[0], numTs - 1);
        this.topDown();
    }

    @Override
    public boolean isAt(int i) {
        return false;
    }

    @Override
    protected boolean analyze(int i) {
        Grammar.Prod[] aprod;
        boolean flag = false;
        for (Grammar.Prod anAprod : aprod = this.grammar.getProds(i)) {
            int[] ai = anAprod.getRhs();
            for (int k = 0; k < ai.length; ++k) {
                int l;
                if (!this.grammar.isNonterminal(ai[k])) continue;
                for (l = k + 1; l < ai.length; ++l) {
                    if (this.grammar.isTerminal(ai[l])) {
                        if (!BitSet.addTo(this.follows[ai[k]], ai[l] - this.numNTs)) break;
                        flag = true;
                        break;
                    }
                    if (BitSet.addTo(this.follows[ai[k]], this.first.at(ai[l]))) {
                        flag = true;
                    }
                    if (!this.nullable.isAt(ai[l])) break;
                }
                if (l < ai.length || !BitSet.addTo(this.follows[ai[k]], this.follows[i])) continue;
                flag = true;
            }
        }
        return flag;
    }

    public int[] at(int i) {
        return this.follows[i];
    }

    public void display(Writer writer) throws IOException {
        writer.write("Follow sets:\n");
        for (int i = 0; i < this.follows.length; ++i) {
            writer.write(" Follow(" + this.grammar.getSymbol(i) + "): {");
            writer.write(this.grammar.displaySymbolSet(this.at(i), this.numNTs));
            writer.write("}\n");
        }
    }
}

