/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jacc.grammar;

import java.io.IOException;
import java.io.Writer;
import org.xbib.jacc.grammar.First;
import org.xbib.jacc.grammar.Grammar;
import org.xbib.jacc.grammar.LR0Items;
import org.xbib.jacc.grammar.LookaheadMachine;
import org.xbib.jacc.grammar.Nullable;
import org.xbib.jacc.util.BitSet;
import org.xbib.jacc.util.IntSet;
import org.xbib.jacc.util.SCC;

public class LALRMachine
extends LookaheadMachine {
    private final Nullable nullable;
    private final First first;
    private final int[][] predState;
    private int numGotos;
    private int[] stateFirstGoto;
    private int[] gotoSource;
    private int[] gotoTrans;
    private int[][] gotoLA;
    private int[][] gotoTargets;
    private int[][][] laReds;

    public LALRMachine(Grammar grammar) {
        super(grammar);
        this.nullable = grammar.getNullable();
        this.first = grammar.getFirst();
        this.predState = SCC.invert(this.succState, this.numStates);
        this.calcGotoLA();
        this.calcLookahead();
    }

    @Override
    public int[] getLookaheadAt(int i, int j) {
        return this.laReds[i][j];
    }

    private void calcGotoLA() {
        int[][] ai;
        this.stateFirstGoto = new int[this.numStates];
        this.numGotos = 0;
        for (int i = 0; i < this.numStates; ++i) {
            this.stateFirstGoto[i] = this.numGotos;
            this.numGotos += this.getGotosAt(i).length;
        }
        this.gotoSource = new int[this.numGotos];
        this.gotoTrans = new int[this.numGotos];
        int j = 0;
        for (int k = 0; k < this.numStates; ++k) {
            int[] ai1;
            int[] nArray = ai1 = this.getGotosAt(k);
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int a = nArray[i];
                this.gotoSource[j] = k;
                this.gotoTrans[j] = a;
                ++j;
            }
        }
        this.gotoLA = new int[this.numGotos][];
        this.gotoTargets = new int[this.numGotos][];
        for (int l = 0; l < this.numGotos; ++l) {
            this.calcTargets(l);
        }
        for (int[] ai2 : ai = SCC.get(this.gotoTargets)) {
            boolean flag = true;
            while (flag) {
                flag = false;
                for (int k1 = 0; k1 < ai2.length; ++k1) {
                    int[] ai3;
                    for (int a : ai3 = this.gotoTargets[ai2[k1]]) {
                        if (!BitSet.addTo(this.gotoLA[ai2[k1]], this.gotoLA[a])) continue;
                        flag = true;
                    }
                }
            }
        }
    }

    private void calcTargets(int i) {
        int j = this.gotoSource[i];
        int k = this.gotoTrans[i];
        int l = this.getEntry(k);
        IntSet intset = this.getItemsAt(k);
        int i1 = intset.size();
        int[] ai = BitSet.make(this.numTs);
        IntSet intset1 = IntSet.empty();
        for (int j1 = 0; j1 < i1; ++j1) {
            LR0Items.Item item = this.items.getItem(intset.at(j1));
            int k1 = item.getLhs();
            int l1 = item.getPos();
            if (k1 >= 0) {
                int[] ai1 = item.getProd().getRhs();
                if (l1 <= 0 || ai1[--l1] != l || !this.calcFirsts(ai, item).canReduce()) continue;
                this.findTargets(intset1, j, k1, ai1, l1);
                continue;
            }
            if (l1 <= 0) continue;
            BitSet.set(ai, this.numTs - 1);
        }
        this.gotoLA[i] = ai;
        this.gotoTargets[i] = intset1.toArray();
    }

    private LR0Items.Item calcFirsts(int[] ai, LR0Items.Item it) {
        LR0Items.Item item = it;
        while (item.canGoto()) {
            int i = item.getNextSym();
            if (this.grammar.isTerminal(i)) {
                BitSet.addTo(ai, i - this.numNTs);
                break;
            }
            BitSet.union(ai, this.first.at(i));
            if (!this.nullable.isAt(i)) break;
            item = this.items.getItem(item.getNextItem());
        }
        if (item.canAccept()) {
            BitSet.set(ai, this.numTs - 1);
        }
        return item;
    }

    private void findTargets(IntSet intset, int i, int j, int[] ai, int kk) {
        block2: {
            int k;
            block3: {
                k = kk;
                if (k != 0) break block3;
                int[] ai1 = this.getGotosAt(i);
                for (int i1 = 0; i1 < ai1.length; ++i1) {
                    if (this.getEntry(ai1[i1]) != j) continue;
                    intset.add(this.stateFirstGoto[i] + i1);
                    break block2;
                }
                break block2;
            }
            if (this.entry[i] != ai[--k]) break block2;
            for (int l = 0; l < this.predState[i].length; ++l) {
                this.findTargets(intset, this.predState[i][l], j, ai, k);
            }
        }
    }

    private void calcLookahead() {
        this.laReds = new int[this.numStates][][];
        for (int i = 0; i < this.numStates; ++i) {
            int[] ai = this.getReducesAt(i);
            IntSet intset = this.getItemsAt(i);
            this.laReds[i] = new int[ai.length][];
            for (int j = 0; j < ai.length; ++j) {
                LR0Items.Item item = this.items.getItem(intset.at(ai[j]));
                int k = item.getLhs();
                int[] ai1 = item.getProd().getRhs();
                int[] ai2 = BitSet.make(this.numTs);
                this.lookBack(ai2, i, k, ai1, ai1.length);
                this.laReds[i][j] = ai2;
            }
        }
    }

    private void lookBack(int[] ai, int i, int j, int[] ai1, int kk) {
        block3: {
            int k;
            block2: {
                k = kk;
                if (k != 0) break block2;
                int[] ai2 = this.getGotosAt(i);
                for (int i1 = 0; i1 < ai2.length; ++i1) {
                    if (this.getEntry(ai2[i1]) != j) continue;
                    BitSet.union(ai, this.gotoLA[this.stateFirstGoto[i] + i1]);
                    return;
                }
                break block3;
            }
            if (this.entry[i] != ai1[--k]) break block3;
            for (int l = 0; l < this.predState[i].length; ++l) {
                this.lookBack(ai, this.predState[i][l], j, ai1, k);
            }
        }
    }

    @Override
    public void display(Writer writer) throws IOException {
        super.display(writer);
        for (int i = 0; i < this.numGotos; ++i) {
            writer.write("Goto #" + i + ", in state " + this.gotoSource[i] + " on symbol " + this.grammar.getSymbol(this.getEntry(this.gotoTrans[i])) + " to state " + this.gotoTrans[i] + "\n");
            writer.write("  Lookahead: {");
            writer.write(this.grammar.displaySymbolSet(this.gotoLA[i], this.numNTs));
            writer.write("}\n");
            writer.write("  Targets  : {");
            for (int k = 0; k < this.gotoTargets[i].length; ++k) {
                if (k > 0) {
                    writer.write(", ");
                }
                writer.write(this.gotoTargets[i][k]);
            }
            writer.write("}\n");
        }
        for (int j = 0; j < this.numStates; ++j) {
            int[] ai = this.getReducesAt(j);
            if (ai.length <= 0) continue;
            writer.write("State " + j + ":\n");
            IntSet intset = this.getItemsAt(j);
            for (int l = 0; l < ai.length; ++l) {
                LR0Items.Item item = this.items.getItem(intset.at(ai[l]));
                writer.write("  Item     : ");
                item.display(writer);
                writer.write("\n");
                writer.write("  Lookahead: {");
                writer.write(this.grammar.displaySymbolSet(this.laReds[j][l], this.numNTs));
                writer.write("}\n");
            }
        }
    }
}

