/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jacc.util;

import org.xbib.jacc.util.BitSetInterator;
import org.xbib.jacc.util.Interator;

public class BitSet {
    private static final int LOG_BITS_PER_WORD = 5;
    private static final int BITS_PER_WORD = 32;

    private BitSet() {
    }

    public static int[] make(int i) {
        return new int[i + 32 - 1 >> 5];
    }

    public static void clear(int[] ai) {
        for (int i = 0; i < ai.length; ++i) {
            ai[i] = 0;
        }
    }

    public static boolean isEmpty(int[] ai) {
        for (int anAi : ai) {
            if (anAi == 0) continue;
            return false;
        }
        return true;
    }

    public static void union(int[] ai, int[] ai1) {
        for (int i = 0; i < ai.length; ++i) {
            int n = i;
            ai[n] = ai[n] | ai1[i];
        }
    }

    public static boolean addTo(int[] ai, int[] ai1) {
        if (ai.length < ai1.length) {
            throw new IllegalArgumentException("bitset arguments do not match");
        }
        boolean flag = false;
        for (int i = 0; i < ai1.length; ++i) {
            if (ai1[i] == 0) continue;
            int j = ai[i] | ai1[i];
            if (j != ai[i]) {
                flag = true;
            }
            ai[i] = j;
        }
        return flag;
    }

    public static boolean addTo(int[] ai, int i) {
        int k = i >> 5;
        int j = 1 << (i & 0x1F);
        int l = ai[k] | j;
        if (l != ai[k]) {
            ai[k] = l;
            return true;
        }
        return false;
    }

    public static void set(int[] ai, int i) {
        int k;
        int j = 1 << (i & 0x1F);
        int n = k = i >> 5;
        ai[n] = ai[n] | j;
    }

    public static boolean get(int[] ai, int i) {
        int k = i >> 5;
        int j = 1 << (i & 0x1F);
        return (ai[k] & j) != 0;
    }

    public static int[] members(int[] ai) {
        int i = 0;
        for (int anAi : ai) {
            if (anAi == 0) continue;
            int k = anAi;
            for (int i1 = 0; i1 < 32 && k != 0; k >>= 1, ++i1) {
                if ((k & 1) == 0) continue;
                ++i;
            }
        }
        int[] ai1 = new int[i];
        int l = 0;
        for (int j1 = 0; j1 < ai.length && l < i; ++j1) {
            if (ai[j1] == 0) continue;
            int k1 = j1 << 5;
            int l1 = ai[j1];
            for (int i2 = 0; i2 < 32 && l1 != 0; l1 >>= 1, ++i2) {
                if ((l1 & 1) == 0) continue;
                ai1[l++] = k1 + i2;
            }
        }
        return ai1;
    }

    public static Interator interator(int[] ai, int i) {
        return new BitSetInterator(ai, i);
    }
}

