/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jacc;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.xbib.jacc.JaccLexer;
import org.xbib.jacc.JaccParser;
import org.xbib.jacc.JaccResolver;
import org.xbib.jacc.JaccSettings;
import org.xbib.jacc.JaccTables;
import org.xbib.jacc.compiler.Failure;
import org.xbib.jacc.compiler.Handler;
import org.xbib.jacc.compiler.JavaSource;
import org.xbib.jacc.compiler.Phase;
import org.xbib.jacc.compiler.Position;
import org.xbib.jacc.compiler.Warning;
import org.xbib.jacc.grammar.Finitary;
import org.xbib.jacc.grammar.Grammar;
import org.xbib.jacc.grammar.LookaheadMachine;
import org.xbib.jacc.grammar.Parser;

class JaccJob
extends Phase {
    private final JaccSettings jaccSettings;
    private final JaccParser parser;
    private final Writer writer;
    private JaccTables tables;
    private JaccResolver resolver;

    JaccJob(Handler handler, Writer writer, JaccSettings jaccSettings) {
        super(handler);
        this.writer = writer;
        this.jaccSettings = jaccSettings;
        this.parser = new JaccParser(handler, jaccSettings);
    }

    JaccSettings getJaccSettings() {
        return this.jaccSettings;
    }

    JaccTables getTables() {
        return this.tables;
    }

    JaccResolver getResolver() {
        return this.resolver;
    }

    void parseGrammarStream(Reader reader) throws IOException {
        try (Reader reader1 = reader;
             JaccLexer jacclexer = new JaccLexer(this.getHandler(), new JavaSource(this.getHandler(), reader1));){
            jacclexer.nextToken();
            this.parser.parse(jacclexer);
        }
    }

    void readErrorExamples(Reader reader) throws IOException {
        try (Reader reader1 = reader;
             JaccLexer jacclexer = new JaccLexer(this.getHandler(), new JavaSource(this.getHandler(), reader1));){
            jacclexer.nextToken();
            this.parser.parseErrorExamples(jacclexer, this);
        }
    }

    void readRunExample(Reader reader, boolean flag) throws IOException {
        try (Reader reader1 = reader;
             JaccLexer jacclexer = new JaccLexer(this.getHandler(), new JavaSource(this.getHandler(), reader1));){
            jacclexer.nextToken();
            this.runExample(this.parser.parseSymbols(jacclexer), flag);
        }
    }

    void buildTables() {
        Grammar grammar = this.parser.getGrammar();
        if (grammar == null || !this.allDeriveFinite(grammar)) {
            return;
        }
        LookaheadMachine lookaheadmachine = this.jaccSettings.makeMachine(grammar);
        this.resolver = new JaccResolver(lookaheadmachine);
        this.tables = new JaccTables(lookaheadmachine, this.resolver);
        if (this.tables.getProdUnused() > 0) {
            this.report(new Warning(this.tables.getProdUnused() + " rules never reduced"));
        }
        if (this.resolver.getNumSRConflicts() > 0 || this.resolver.getNumRRConflicts() > 0) {
            this.report(new Warning("conflicts: " + this.resolver.getNumSRConflicts() + " shift/reduce, " + this.resolver.getNumRRConflicts() + " reduce/reduce"));
        }
    }

    private boolean allDeriveFinite(Grammar grammar) {
        Finitary finitary = grammar.getFinitary();
        boolean flag = true;
        for (int i = 0; i < grammar.getNumNTs(); ++i) {
            if (finitary.isAt(i)) continue;
            flag = false;
            this.report(new Failure("No finite strings can be derived for " + grammar.getNonterminal(i)));
        }
        return flag;
    }

    private void runExample(int[] ai, boolean flag) throws IOException {
        Grammar grammar = this.parser.getGrammar();
        Parser parser1 = new Parser(this.tables, ai);
        this.writer.write("start ");
        block7: while (true) {
            this.writer.write(" :  ");
            parser1.display(this.writer, flag);
            switch (parser1.step()) {
                case 0: {
                    this.writer.write("Accept!\n");
                    return;
                }
                case 1: {
                    this.writer.write("error in state ");
                    this.writer.write(parser1.getState());
                    this.writer.write(", next symbol ");
                    this.writer.write(grammar.getSymbol(parser1.getNextSymbol()).toString());
                    return;
                }
                case 3: {
                    this.writer.write("goto  ");
                    continue block7;
                }
                case 2: {
                    this.writer.write("shift ");
                    continue block7;
                }
                case 4: {
                    this.writer.write("reduce");
                    continue block7;
                }
            }
        }
    }

    void errorExample(Position position, String s, int[] ai) {
        int i;
        Parser p = new Parser(this.tables, ai);
        while ((i = p.step()) != 0 && i != 1) {
        }
        if (i == 0) {
            this.report(new Warning(position, "Example for \"" + s + "\" does not produce an error"));
        } else {
            int j;
            Grammar grammar = this.tables.getMachine().getGrammar();
            if (grammar.isNonterminal(j = p.getNextSymbol())) {
                this.report(new Warning(position, "Example for \"" + s + "\" reaches an error at the nonterminal " + grammar.getSymbol(j)));
            } else {
                int k = p.getState();
                if (!this.tables.errorAt(k, j)) {
                    this.report(new Failure(position, "Error example results in internal error"));
                } else {
                    String s1 = this.tables.errorSet(k, j, s);
                    if (s1 != null) {
                        this.report(new Warning(position, "Multiple errors are possible in state " + k + " on terminal " + grammar.getSymbol(j) + ":\n - " + s1 + "\n - " + s));
                    }
                }
            }
        }
    }
}

