/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jacc;

import org.xbib.jacc.Conflicts;
import org.xbib.jacc.Fixity;
import org.xbib.jacc.JaccProd;
import org.xbib.jacc.JaccSymbol;
import org.xbib.jacc.grammar.Grammar;
import org.xbib.jacc.grammar.LR0Items;
import org.xbib.jacc.grammar.LookaheadMachine;
import org.xbib.jacc.grammar.Resolver;
import org.xbib.jacc.grammar.Tables;
import org.xbib.jacc.util.IntSet;

class JaccResolver
implements Resolver {
    private final LookaheadMachine machine;
    private int numSRConflicts = 0;
    private int numRRConflicts = 0;
    private final Conflicts[] conflicts;

    JaccResolver(LookaheadMachine lookaheadmachine) {
        this.machine = lookaheadmachine;
        this.conflicts = new Conflicts[lookaheadmachine.getNumStates()];
    }

    int getNumSRConflicts() {
        return this.numSRConflicts;
    }

    int getNumRRConflicts() {
        return this.numRRConflicts;
    }

    String getConflictsAt(int i) {
        return Conflicts.describe(this.machine, i, this.conflicts[i]);
    }

    @Override
    public void srResolve(Tables tables, int i, int j, int k) {
        Grammar grammar = this.machine.getGrammar();
        Grammar.Symbol symbol = grammar.getTerminal(j);
        IntSet intset = this.machine.getItemsAt(i);
        LR0Items lr0items = this.machine.getItems();
        Grammar.Prod prod = lr0items.getItem(intset.at(k)).getProd();
        if (symbol instanceof JaccSymbol && prod instanceof JaccProd) {
            JaccSymbol jaccsymbol = (JaccSymbol)symbol;
            JaccProd jaccprod = (JaccProd)prod;
            switch (Fixity.which(jaccprod.getFixity(), jaccsymbol.getFixity())) {
                case 1: {
                    tables.setReduce(i, j, k);
                    return;
                }
                case 3: {
                    return;
                }
            }
        }
        this.conflicts[i] = Conflicts.sr(tables.getArgAt(i)[j], k, symbol, this.conflicts[i]);
        ++this.numSRConflicts;
    }

    @Override
    public void rrResolve(Tables tables, int i, int j, int k) {
        Grammar grammar = this.machine.getGrammar();
        int l = tables.getArgAt(i)[j];
        IntSet intset = this.machine.getItemsAt(i);
        LR0Items lr0items = this.machine.getItems();
        Grammar.Prod prod = lr0items.getItem(intset.at(l)).getProd();
        Grammar.Prod prod1 = lr0items.getItem(intset.at(k)).getProd();
        Grammar.Symbol symbol = grammar.getTerminal(j);
        if (prod1.getSeqNo() < prod.getSeqNo()) {
            tables.setReduce(i, j, k);
        }
        this.conflicts[i] = Conflicts.rr(l, k, symbol, this.conflicts[i]);
        ++this.numRRConflicts;
    }
}

