/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jacc;

import org.xbib.jacc.MachineType;
import org.xbib.jacc.grammar.Grammar;
import org.xbib.jacc.grammar.LALRMachine;
import org.xbib.jacc.grammar.LR0Machine;
import org.xbib.jacc.grammar.LookaheadMachine;
import org.xbib.jacc.grammar.SLRMachine;

class JaccSettings {
    private MachineType machineType = MachineType.LALR1;
    private String packageName;
    private String className;
    private String interfaceName;
    private String extendsName;
    private String implementsNames;
    private String typeName;
    private String getToken;
    private String nextToken;
    private String getSemantic;
    private final StringBuilder preTextBuffer = new StringBuilder();
    private final StringBuilder postTextBuffer = new StringBuilder();

    JaccSettings() {
    }

    void setMachineType(MachineType machineType) {
        this.machineType = machineType;
    }

    LookaheadMachine makeMachine(Grammar grammar) {
        switch (this.machineType) {
            case LR0: {
                return new LR0Machine(grammar);
            }
            case SLR1: {
                return new SLRMachine(grammar);
            }
            case LALR1: {
                return new LALRMachine(grammar);
            }
        }
        return null;
    }

    String getPackageName() {
        return this.packageName;
    }

    void setPackageName(String s) {
        this.packageName = s;
    }

    String getClassName() {
        return this.className;
    }

    void setClassName(String s) {
        this.className = s;
    }

    String getInterfaceName() {
        return this.interfaceName;
    }

    void setInterfaceName(String s) {
        this.interfaceName = s;
    }

    String getExtendsName() {
        return this.extendsName;
    }

    void setExtendsName(String s) {
        this.extendsName = s;
    }

    void addImplementsNames(String s) {
        this.implementsNames = this.implementsNames != null ? this.implementsNames + ", " + s : s;
    }

    String getImplementsNames() {
        return this.implementsNames;
    }

    public void setImplementsNames(String s) {
        this.implementsNames = s;
    }

    String getTypeName() {
        return this.typeName;
    }

    void setTypeName(String s) {
        this.typeName = s;
    }

    String getGetToken() {
        return this.getToken;
    }

    void setGetToken(String s) {
        this.getToken = s;
    }

    String getNextToken() {
        return this.nextToken;
    }

    void setNextToken(String s) {
        this.nextToken = s;
    }

    String getGetSemantic() {
        return this.getSemantic;
    }

    void setGetSemantic(String s) {
        this.getSemantic = s;
    }

    void addPreText(String s) {
        this.preTextBuffer.append(s);
    }

    String getPreText() {
        return this.preTextBuffer.toString();
    }

    void addPostText(String s) {
        this.postTextBuffer.append(s);
    }

    String getPostText() {
        return this.postTextBuffer.toString();
    }

    void fillBlanks(String s) {
        if (this.getClassName() == null) {
            this.setClassName(s + "Parser");
        }
        if (this.getInterfaceName() == null) {
            this.setInterfaceName(s + "Tokens");
        }
        if (this.getTypeName() == null) {
            this.setTypeName("Object");
        }
        if (this.getInterfaceName() != null) {
            this.addImplementsNames(this.getInterfaceName());
        }
        if (this.getGetSemantic() == null) {
            this.setGetSemantic("lexer.getSemantic()");
        }
        if (this.getGetToken() == null) {
            this.setGetToken("lexer.getToken()");
        }
        if (this.getNextToken() == null) {
            this.setNextToken("lexer.nextToken()");
        }
    }
}

