/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jacc;

import java.io.IOException;
import java.io.Writer;
import org.xbib.jacc.grammar.LookaheadMachine;
import org.xbib.jacc.grammar.Resolver;
import org.xbib.jacc.grammar.Tables;

class JaccTables
extends Tables {
    private String[] errors = null;
    private int numErrors = 0;
    private int[][] index;
    private int[] defaultRow;

    JaccTables(LookaheadMachine lookaheadmachine, Resolver resolver) {
        super(lookaheadmachine, resolver);
    }

    int getNumErrors() {
        return this.numErrors;
    }

    String getError(int i) {
        return this.errors[i];
    }

    boolean errorAt(int i, int j) {
        return this.action[i][j - this.numNTs] == 0;
    }

    String errorSet(int i, int j, String s) {
        if (this.arg[i][j - this.numNTs] != 0) {
            return this.errors[this.arg[i][j - this.numNTs] - 1];
        }
        this.arg[i][j - this.numNTs] = this.errorNo(s) + 1;
        return null;
    }

    private int errorNo(String s) {
        for (int i = 0; i < this.numErrors; ++i) {
            if (!this.errors[i].equals(s)) continue;
            return i;
        }
        String[] as = new String[this.numErrors != 0 ? 2 * this.numErrors : 1];
        if (this.errors != null) {
            System.arraycopy(this.errors, 0, as, 0, this.numErrors);
        }
        this.errors = as;
        this.errors[this.numErrors] = s;
        return this.numErrors++;
    }

    void analyzeRows() {
        if (this.index == null) {
            RowAnalysis rowanalysis = new RowAnalysis();
            int i = this.machine.getNumStates();
            this.index = new int[i][];
            this.defaultRow = new int[i];
            for (int j = 0; j < i; ++j) {
                rowanalysis.analyze(j);
            }
        }
    }

    int[] indexAt(int i) {
        return this.index[i];
    }

    int getDefaultRowAt(int i) {
        return this.defaultRow[i];
    }

    public void display(Writer writer) throws IOException {
        int i = this.machine.getNumStates();
        for (int j = 0; j < i; ++j) {
            writer.write("state " + j + ":\n");
            for (int k = 0; k < this.numTs; ++k) {
                switch (this.action[j][k]) {
                    case 0: {
                        writer.write(" E");
                        break;
                    }
                    case 1: {
                        writer.write(" S");
                        break;
                    }
                    case 2: {
                        writer.write(" R");
                        break;
                    }
                }
                writer.write(this.arg[j][k]);
            }
            writer.write("\n");
        }
    }

    private class RowAnalysis {
        private byte[] a;
        private int[] b;
        private int size;
        private int[] idx;

        private RowAnalysis() {
        }

        void analyze(int i) {
            this.a = JaccTables.this.action[i];
            this.b = JaccTables.this.arg[i];
            this.size = JaccTables.this.numTs;
            this.idx = new int[this.size];
            for (int j = 0; j < JaccTables.this.numTs; ++j) {
                this.idx[j] = j;
            }
            for (int k = this.size / 2; k >= 0; --k) {
                this.heapify(k);
            }
            for (int l = this.size - 1; l > 0; --l) {
                int i1 = this.idx[l];
                this.idx[l] = this.idx[0];
                this.idx[0] = i1;
                --this.size;
                this.heapify(0);
            }
            JaccTables.this.index[i] = this.idx;
            JaccTables.this.defaultRow[i] = this.findDefault();
        }

        private void heapify(int pos) {
            int i;
            int j = i = pos;
            int k = this.idx[j];
            while (true) {
                int l = 2 * i + 1;
                int i1 = l + 1;
                if (l < this.size) {
                    int k1;
                    int j1 = this.idx[l];
                    if (this.a[j1] > this.a[k] || this.a[j1] == this.a[k] && this.b[j1] > this.b[k]) {
                        j = l;
                        k = j1;
                    }
                    if (i1 < this.size && (this.a[k1 = this.idx[i1]] > this.a[k] || this.a[k1] == this.a[k] && this.b[k1] > this.b[k])) {
                        j = i1;
                        k = k1;
                    }
                }
                if (j == i) {
                    return;
                }
                this.idx[j] = this.idx[i];
                this.idx[i] = k;
                i = j;
                k = this.idx[j];
            }
        }

        int findDefault() {
            int i = 1;
            int j = -1;
            int k = 0;
            while (k < this.a.length) {
                int l = this.idx[k];
                byte byte0 = this.a[l];
                if (byte0 == 1) {
                    ++k;
                    continue;
                }
                int j1 = 1;
                int k1 = this.b[l];
                while (++k < this.a.length && this.a[this.idx[k]] == byte0 && this.b[this.idx[k]] == k1) {
                    ++j1;
                }
                if (j1 <= i) continue;
                j = l;
                i = j1;
            }
            return j;
        }
    }
}

