/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jacc.compiler;

import org.xbib.jacc.compiler.Position;
import org.xbib.jacc.compiler.Source;

class SourcePosition
implements Position {
    private final Source source;
    private int row;
    private int column;

    SourcePosition(Source source) {
        this(source, 0, 0);
    }

    private SourcePosition(Source source, int i, int j) {
        this.source = source;
        this.row = i;
        this.column = j;
    }

    void updateCoords(int i, int j) {
        this.row = i;
        this.column = j;
    }

    @Override
    public String describe() {
        StringBuilder sb = new StringBuilder();
        if (this.source != null) {
            String s;
            if (this.row > 0) {
                sb.append(", ");
            }
            if (this.row > 0) {
                sb.append("line ");
                sb.append(this.row);
            }
            if ((s = this.source.getLine(this.row)) != null) {
                sb.append('\n');
                sb.append(s);
                sb.append('\n');
                for (int i = 0; i < this.column; ++i) {
                    sb.append(' ');
                }
                sb.append('^');
            }
        }
        return sb.length() > 0 ? sb.toString() : "input";
    }

    @Override
    public Position copy() {
        return new SourcePosition(this.source, this.row, this.column);
    }
}

