/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jacc.grammar;

import java.io.IOException;
import java.io.Writer;
import org.xbib.jacc.grammar.Grammar;

abstract class Analysis {
    private int[][] comps;

    Analysis(int[][] ai) {
        this.comps = ai;
    }

    void bottomUp() {
        for (int[] comp : this.comps) {
            this.analyzeComponent(comp);
        }
    }

    void topDown() {
        int i = this.comps.length;
        while (i-- > 0) {
            this.analyzeComponent(this.comps[i]);
        }
    }

    private void analyzeComponent(int[] ai) {
        boolean flag = true;
        while (flag) {
            flag = false;
            for (int i = 0; i < ai.length; ++i) {
                flag |= this.analyze(ai[i]);
            }
        }
    }

    public void display(Writer writer, int numNTs, Grammar grammar) throws IOException {
        int i = 0;
        for (int j = 0; j < numNTs; ++j) {
            if (!this.isAt(j)) continue;
            if (i > 0) {
                writer.write(", ");
            }
            writer.write(grammar.getSymbol(j).getName());
            ++i;
        }
    }

    public abstract boolean isAt(int var1);

    protected abstract boolean analyze(int var1);
}

