/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jacc.grammar;

import java.io.IOException;
import java.io.Writer;
import org.xbib.jacc.grammar.Analysis;
import org.xbib.jacc.grammar.Grammar;

public final class Finitary
extends Analysis {
    private final boolean[] finitaries;
    private final boolean[] consider;
    private final Grammar grammar;
    private final int numNTs;

    Finitary(Grammar grammar) {
        super(grammar.getComponents());
        this.grammar = grammar;
        this.numNTs = grammar.getNumNTs();
        this.finitaries = new boolean[this.numNTs];
        this.consider = new boolean[this.numNTs];
        for (int i = 0; i < this.numNTs; ++i) {
            this.finitaries[i] = false;
            this.consider[i] = true;
        }
        this.bottomUp();
    }

    @Override
    protected boolean analyze(int i) {
        boolean flag = false;
        if (this.consider[i]) {
            Grammar.Prod[] prods;
            int j = 0;
            for (Grammar.Prod prod : prods = this.grammar.getProds(i)) {
                int l;
                int[] ai = prod.getRhs();
                for (l = 0; l < ai.length && this.isAt(ai[l]); ++l) {
                }
                if (l >= ai.length) {
                    this.finitaries[i] = true;
                    this.consider[i] = false;
                    flag = true;
                    break;
                }
                if (this.consider[ai[l]]) continue;
                ++j;
            }
            if (j == prods.length) {
                this.consider[i] = false;
            }
        }
        return flag;
    }

    @Override
    public boolean isAt(int i) {
        return this.grammar.isTerminal(i) || this.finitaries[i];
    }

    public void display(Writer writer) throws IOException {
        writer.write("Finitary = {");
        super.display(writer, this.numNTs, this.grammar);
        writer.write("}\n");
    }
}

