/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jacc.grammar;

import java.io.IOException;
import java.io.Writer;
import org.xbib.jacc.grammar.Analysis;
import org.xbib.jacc.grammar.Grammar;
import org.xbib.jacc.grammar.Nullable;
import org.xbib.jacc.util.BitSet;

public class First
extends Analysis {
    private Grammar grammar;
    private Nullable nullable;
    private int numNTs;
    private int[][] firsts;

    First(Grammar grammar1, Nullable nullable1) {
        super(grammar1.getComponents());
        this.grammar = grammar1;
        this.nullable = nullable1;
        this.numNTs = grammar1.getNumNTs();
        int numTs = grammar1.getNumTs();
        this.firsts = new int[this.numNTs][];
        for (int i = 0; i < this.numNTs; ++i) {
            this.firsts[i] = BitSet.make(numTs);
        }
        this.bottomUp();
    }

    @Override
    public boolean isAt(int i) {
        return false;
    }

    @Override
    protected boolean analyze(int i) {
        Grammar.Prod[] aprod;
        boolean flag = false;
        block0: for (Grammar.Prod anAprod : aprod = this.grammar.getProds(i)) {
            int[] ai = anAprod.getRhs();
            for (int k = 0; k < ai.length; ++k) {
                if (this.grammar.isTerminal(ai[k])) {
                    if (!BitSet.addTo(this.firsts[i], ai[k] - this.numNTs)) continue block0;
                    flag = true;
                    continue block0;
                }
                if (BitSet.addTo(this.firsts[i], this.firsts[ai[k]])) {
                    flag = true;
                }
                if (!this.nullable.isAt(ai[k])) continue block0;
            }
        }
        return flag;
    }

    public int[] at(int i) {
        return this.firsts[i];
    }

    public void display(Writer writer) throws IOException {
        writer.write("First sets:\n");
        for (int i = 0; i < this.firsts.length; ++i) {
            writer.write(" First(" + this.grammar.getSymbol(i) + "): {");
            writer.write(this.grammar.displaySymbolSet(this.at(i), this.numNTs));
            writer.write("}\n");
        }
    }
}

