/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jacc.grammar;

import java.io.IOException;
import java.io.Writer;
import org.xbib.jacc.JaccException;
import org.xbib.jacc.grammar.Finitary;
import org.xbib.jacc.grammar.First;
import org.xbib.jacc.grammar.Follow;
import org.xbib.jacc.grammar.Left;
import org.xbib.jacc.grammar.Nullable;
import org.xbib.jacc.util.BitSet;
import org.xbib.jacc.util.Interator;
import org.xbib.jacc.util.SCC;

public class Grammar {
    private final Symbol[] symbols;
    private final Prod[][] prods;
    private int numSyms;
    private int numNTs;
    private int numTs;
    private int[][] comps;
    private int[][] depends;
    private int[][] revdeps;
    private Nullable nullable;
    private Finitary finitary;
    private Left left;
    private First first;
    private Follow follow;

    public Grammar(Symbol[] symbols, Prod[][] prods) throws JaccException {
        Grammar.validate(symbols, prods);
        this.symbols = symbols;
        this.numSyms = symbols.length;
        this.prods = prods;
        this.numNTs = prods.length;
        this.numTs = this.numSyms - this.numNTs;
        this.calcDepends();
        this.comps = SCC.get(this.depends, this.revdeps, this.numNTs);
    }

    private static void validate(Symbol[] symbol, Prod[][] prod) throws JaccException {
        if (symbol == null || symbol.length == 0) {
            throw new JaccException("No symbols specified");
        }
        for (int i = 0; i < symbol.length; ++i) {
            if (symbol[i] != null) continue;
            throw new JaccException("Symbol " + i + " is null");
        }
        int j = symbol.length;
        if (prod == null || prod.length == 0) {
            throw new JaccException("No nonterminals specified");
        }
        if (prod.length > j) {
            throw new JaccException("To many nonterminals specified");
        }
        if (prod.length == j) {
            throw new JaccException("No terminals specified");
        }
        for (int k = 0; k < prod.length; ++k) {
            if (prod[k] == null || prod[k].length == 0) {
                throw new JaccException("Nonterminal " + symbol[k] + " (number " + k + ") has no productions");
            }
            for (int l = 0; l < prod[k].length; ++l) {
                int[] ai = prod[k][l].getRhs();
                if (ai == null) {
                    throw new JaccException("Production " + l + " for symbol " + symbol[k] + " (number " + k + ") is null");
                }
                for (int m : ai) {
                    if (m >= 0 && m < j - 1) continue;
                    throw new JaccException("Out of range symbol " + m + " in production " + l + " for symbol " + symbol[k] + " (number " + k + ")");
                }
            }
        }
    }

    public int getNumSyms() {
        return this.numSyms;
    }

    public int getNumNTs() {
        return this.numNTs;
    }

    public int getNumTs() {
        return this.numTs;
    }

    public Symbol getSymbol(int i) {
        return this.symbols[i];
    }

    Symbol getStart() {
        return this.symbols[0];
    }

    Symbol getEnd() {
        return this.symbols[this.numSyms - 1];
    }

    public Symbol getNonterminal(int i) {
        return this.symbols[i];
    }

    public Symbol getTerminal(int i) {
        return this.symbols[this.numNTs + i];
    }

    public boolean isNonterminal(int i) {
        return 0 <= i && i < this.numNTs;
    }

    public boolean isTerminal(int i) {
        return this.numNTs <= i && i < this.numSyms;
    }

    public int getNumProds() {
        int i = 0;
        for (Prod[] prod : this.prods) {
            i += prod.length;
        }
        return i;
    }

    public Prod[] getProds(int i) {
        return this.prods[i];
    }

    int[][] getComponents() {
        return this.comps;
    }

    private void calcDepends() {
        int[][] ai = new int[this.numNTs][];
        int[] ai1 = BitSet.make(this.numNTs);
        this.depends = new int[this.numNTs][];
        for (int i = 0; i < this.numNTs; ++i) {
            ai[i] = BitSet.make(this.numNTs);
        }
        for (int j = 0; j < this.numNTs; ++j) {
            BitSet.clear(ai1);
            for (int l = 0; l < this.prods[j].length; ++l) {
                int[] ai2;
                for (int anAi2 : ai2 = this.prods[j][l].getRhs()) {
                    if (!this.isNonterminal(anAi2)) continue;
                    BitSet.set(ai[anAi2], j);
                    BitSet.set(ai1, anAi2);
                }
            }
            this.depends[j] = BitSet.members(ai1);
        }
        this.revdeps = new int[this.numNTs][];
        for (int k = 0; k < this.numNTs; ++k) {
            this.revdeps[k] = BitSet.members(ai[k]);
        }
    }

    public Nullable getNullable() {
        if (this.nullable == null) {
            this.nullable = new Nullable(this);
        }
        return this.nullable;
    }

    public Finitary getFinitary() {
        if (this.finitary == null) {
            this.finitary = new Finitary(this);
        }
        return this.finitary;
    }

    public Left getLeft() {
        if (this.left == null) {
            this.left = new Left(this);
        }
        return this.left;
    }

    public First getFirst() {
        if (this.first == null) {
            this.first = new First(this, this.getNullable());
        }
        return this.first;
    }

    public Follow getFollow() {
        if (this.follow == null) {
            this.follow = new Follow(this, this.getNullable(), this.getFirst());
        }
        return this.follow;
    }

    public void display(Writer writer) throws IOException {
        for (int i = 0; i < this.numNTs; ++i) {
            writer.write(this.symbols[i].getName() + "\n");
            String s = " = ";
            for (int j = 0; j < this.prods[i].length; ++j) {
                int[] ai = this.prods[i][j].getRhs();
                writer.write(s);
                writer.write(this.displaySymbols(ai, "/* empty */", " ") + "\n");
                s = " | ";
            }
            writer.write(" ;\n");
        }
    }

    public String displaySymbols(int[] ai, String s, String s1) {
        return this.displaySymbols(ai, 0, ai.length, s, s1);
    }

    String displaySymbols(int[] ai, int i, int j, String s, String s1) {
        if (ai == null || i >= j) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.symbols[ai[i]].getName());
        for (int k = i + 1; k < j; ++k) {
            sb.append(s1);
            sb.append(this.symbols[ai[k]].getName());
        }
        return sb.toString();
    }

    String displaySymbolSet(int[] ai, int i) {
        StringBuilder sb = new StringBuilder();
        int j = 0;
        Interator interator = BitSet.interator(ai, i);
        while (interator.hasNext()) {
            if (j++ > 0) {
                sb.append(", ");
            }
            sb.append(this.symbols[interator.next()].getName());
        }
        return sb.toString();
    }

    public static class Symbol {
        String name;

        public Symbol(String s) {
            this.name = s;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Prod {
        private int[] rhs;
        private int seqNo;

        public Prod(int[] ai, int i) {
            this.rhs = ai;
            this.seqNo = i;
        }

        public int[] getRhs() {
            return this.rhs;
        }

        public int getSeqNo() {
            return this.seqNo;
        }

        public String getLabel() {
            return null;
        }
    }
}

