/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jacc.grammar;

import org.xbib.jacc.grammar.Grammar;
import org.xbib.jacc.grammar.LR0Items;
import org.xbib.jacc.grammar.LookaheadMachine;
import org.xbib.jacc.grammar.Resolver;
import org.xbib.jacc.util.BitSet;
import org.xbib.jacc.util.IntSet;
import org.xbib.jacc.util.Interator;

public class Tables {
    private static final byte NONE = 0;
    private static final byte SHIFT = 1;
    private static final byte REDUCE = 2;
    protected LookaheadMachine machine;
    protected int numNTs;
    protected int numTs;
    protected byte[][] action;
    protected int[][] arg;
    private Resolver resolver;
    private boolean[][] prodUsed;
    private int prodUnused;

    public Tables(LookaheadMachine lookaheadmachine, Resolver resolver) {
        this.machine = lookaheadmachine;
        this.resolver = resolver;
        Grammar grammar = lookaheadmachine.getGrammar();
        this.numNTs = grammar.getNumNTs();
        this.numTs = grammar.getNumTs();
        int i = lookaheadmachine.getNumStates();
        this.action = new byte[i][];
        this.arg = new int[i][];
        this.prodUsed = new boolean[this.numNTs][];
        this.prodUnused = 0;
        for (int j = 0; j < this.numNTs; ++j) {
            this.prodUsed[j] = new boolean[grammar.getProds(j).length];
            this.prodUnused += this.prodUsed[j].length;
        }
        for (int k = 0; k < i; ++k) {
            this.fillTablesAt(k);
        }
    }

    public LookaheadMachine getMachine() {
        return this.machine;
    }

    public byte[] getActionAt(int i) {
        return this.action[i];
    }

    public int[] getArgAt(int i) {
        return this.arg[i];
    }

    public int getProdUnused() {
        return this.prodUnused;
    }

    public boolean[] getProdsUsedAt(int i) {
        return this.prodUsed[i];
    }

    private void setShift(int i, int j, int k) {
        this.action[i][j] = 1;
        this.arg[i][j] = k;
    }

    public void setReduce(int i, int j, int k) {
        this.action[i][j] = 2;
        this.arg[i][j] = k;
    }

    private void fillTablesAt(int i) {
        this.action[i] = new byte[this.numTs];
        this.arg[i] = new int[this.numTs];
        int[] ai = this.machine.getShiftsAt(i);
        int[] ai1 = this.machine.getReducesAt(i);
        for (int anAi : ai) {
            this.setShift(i, this.machine.getEntry(anAi) - this.numNTs, anAi);
        }
        for (int k = 0; k < ai1.length; ++k) {
            Interator interator = BitSet.interator(this.machine.getLookaheadAt(i, k), 0);
            while (interator.hasNext()) {
                int l = interator.next();
                switch (this.action[i][l]) {
                    case 0: {
                        this.setReduce(i, l, ai1[k]);
                        break;
                    }
                    case 1: {
                        this.resolver.srResolve(this, i, l, ai1[k]);
                        break;
                    }
                    case 2: {
                        this.resolver.rrResolve(this, i, l, ai1[k]);
                        break;
                    }
                }
            }
        }
        LR0Items lr0items = this.machine.getItems();
        IntSet intset = this.machine.getItemsAt(i);
        for (int anAi1 : ai1) {
            for (int j1 = 0; j1 < this.numTs; ++j1) {
                int l1;
                LR0Items.Item item;
                int k1;
                if (this.action[i][j1] != 2 || this.arg[i][j1] != anAi1 || this.prodUsed[k1 = (item = lr0items.getItem(intset.at(anAi1))).getLhs()][l1 = item.getProdNo()]) continue;
                this.prodUsed[k1][l1] = true;
                --this.prodUnused;
            }
        }
    }
}

