/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jacc.util;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import org.xbib.jacc.util.ElemInterator;
import org.xbib.jacc.util.Interator;

public class IntSet {
    private int[] elems = new int[1];
    private int used = 0;

    private IntSet() {
    }

    public static IntSet empty() {
        return new IntSet();
    }

    public static IntSet singleton(int i) {
        IntSet intset = new IntSet();
        intset.add(i);
        return intset;
    }

    public int size() {
        return this.used;
    }

    public int at(int i) {
        return this.elems[i];
    }

    public int[] toArray() {
        int[] ai = new int[this.used];
        System.arraycopy(this.elems, 0, ai, 0, this.used);
        return ai;
    }

    public boolean contains(int i) {
        int j = 0;
        int k = this.used;
        while (j < k) {
            int l = j + (k - j) / 2;
            int i1 = this.elems[l];
            if (i == i1) {
                return true;
            }
            if (i < i1) {
                k = l;
                continue;
            }
            j = l + 1;
        }
        return false;
    }

    public void add(int i) {
        int j = 0;
        int k = this.used;
        while (j < k) {
            int l = j + (k - j) / 2;
            int j1 = this.elems[l];
            if (i < j1) {
                k = l;
                continue;
            }
            if (i == j1) {
                return;
            }
            j = l + 1;
        }
        if (this.used >= this.elems.length) {
            int[] ai = new int[this.elems.length * 2];
            System.arraycopy(this.elems, 0, ai, 0, j);
            ai[j] = i;
            System.arraycopy(this.elems, j, ai, j + 1, this.used - j);
            this.elems = ai;
        } else {
            System.arraycopy(this.elems, j, this.elems, j + 1, this.used - j);
            this.elems[j] = i;
        }
        ++this.used;
    }

    public boolean equals(Object o) {
        if (!(o instanceof IntSet)) {
            return false;
        }
        IntSet intset = (IntSet)o;
        if (this.used == intset.used) {
            for (int i = 0; i < this.used; ++i) {
                if (this.elems[i] == intset.elems[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.elems);
    }

    public Interator interator() {
        return new ElemInterator(this.elems, 0, this.used);
    }

    public void display(Writer writer) throws IOException {
        Interator interator1 = this.interator();
        writer.write("{");
        int i = 0;
        while (interator1.hasNext()) {
            if (i != 0) {
                writer.write(", ");
            }
            writer.write(interator1.next());
            ++i;
        }
        writer.write("}");
        writer.write(": used = " + this.used + ", length = " + this.elems.length + "\n");
    }
}

