/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jacc.util;

import org.xbib.jacc.util.BitSet;
import org.xbib.jacc.util.ElemInterator;
import org.xbib.jacc.util.Interator;
import org.xbib.jacc.util.SeqInterator;

public class SCC {
    public static int[][] get(int[][] ai, int[][] ai1, int i) {
        return new GetComponents(ai, i, new ArrangeByFinish(ai1, i).getFinishOrder()).getComponents();
    }

    public static int[][] get(int[][] ai) {
        return SCC.get(ai, SCC.invert(ai), ai.length);
    }

    private static int[][] invert(int[][] ai) {
        return SCC.invert(ai, ai.length);
    }

    public static int[][] invert(int[][] ai, int i) {
        int[] ai1 = new int[i];
        for (int j = 0; j < i; ++j) {
            for (int k = 0; k < ai[j].length; ++k) {
                int n = ai[j][k];
                ai1[n] = ai1[n] + 1;
            }
        }
        int[][] ai2 = new int[i][];
        for (int l = 0; l < i; ++l) {
            ai2[l] = new int[ai1[l]];
        }
        for (int i1 = 0; i1 < i; ++i1) {
            for (int j1 = 0; j1 < ai[i1].length; ++j1) {
                int k1;
                int n = k1 = ai[i1][j1];
                ai1[n] = ai1[n] - 1;
                ai2[k1][ai1[k1]] = i1;
            }
        }
        return ai2;
    }

    private static class GetComponents
    extends DepthFirst {
        private int numComps = 0;
        private int[] compNo;

        GetComponents(int[][] ai, int i, int[] ai1) {
            super(new ElemInterator(ai1), ai);
            this.compNo = new int[i];
        }

        @Override
        void doneVisit(int i) {
            this.compNo[i] = this.numComps;
        }

        @Override
        void doneTree() {
            ++this.numComps;
        }

        int[][] getComponents() {
            this.search();
            int[] ai = new int[this.numComps];
            int[] nArray = this.compNo;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int aCompNo;
                int n2 = aCompNo = nArray[i];
                ai[n2] = ai[n2] + 1;
            }
            int[][] ai1 = new int[this.numComps][];
            for (int j = 0; j < this.numComps; ++j) {
                ai1[j] = new int[ai[j]];
            }
            int k = 0;
            while (k < this.compNo.length) {
                int l;
                int n3 = l = this.compNo[k];
                int n4 = ai[n3] - 1;
                ai[n3] = n4;
                ai1[l][n4] = k++;
            }
            return ai1;
        }
    }

    private static class ArrangeByFinish
    extends DepthFirst {
        private int dfsNum;
        private int[] order;

        ArrangeByFinish(int[][] ai, int i) {
            super(new SeqInterator(0, i), ai);
            this.dfsNum = i;
            this.order = new int[this.dfsNum];
        }

        @Override
        void doneVisit(int i) {
            this.order[--this.dfsNum] = i;
        }

        @Override
        void doneTree() {
        }

        int[] getFinishOrder() {
            this.search();
            return this.order;
        }
    }

    static abstract class DepthFirst {
        private Interator seq;
        private int[][] adjs;
        private int[] visited;

        DepthFirst(Interator interator, int[][] ai) {
            this.seq = interator;
            this.adjs = ai;
            this.visited = BitSet.make(ai.length);
        }

        void search() {
            while (this.seq.hasNext()) {
                if (!this.visit(this.seq.next())) continue;
                this.doneTree();
            }
        }

        private boolean visit(int i) {
            if (BitSet.addTo(this.visited, i)) {
                int[] ai;
                for (int j : ai = this.adjs[i]) {
                    this.visit(j);
                }
                this.doneVisit(i);
                return true;
            }
            return false;
        }

        abstract void doneVisit(int var1);

        abstract void doneTree();
    }
}

