/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.gs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.xbib.graphics.gs.FontAnalysisItem;
import org.xbib.graphics.gs.Ghostscript;

public class FontAnalyzer {
    /*
     * Could not resolve type clashes
     * Loose catch block
     */
    public synchronized List<FontAnalysisItem> analyze(Path path) throws IOException {
        Ghostscript gs = Ghostscript.getInstance();
        String[] gsArgs = new String[]{"-fonta", "-dQUIET", "-dNOPAUSE", "-dBATCH", "-dNODISPLAY", "-sFile=" + path.toAbsolutePath().toString(), "-sOutputFile=%stdout", "-f", "-"};
        try {
            try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("script/AnalyzePDFFonts.ps");){
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                gs.setStdIn(is);
                gs.setStdOut(baos);
                gs.initialize(gsArgs);
                ArrayList<FontAnalysisItem> result = new ArrayList<FontAnalysisItem>();
                String s = baos.toString();
                String[] lines = s.split("\n");
                boolean inResults = false;
                for (String line : lines) {
                    String[] columns;
                    if (line.equals("---")) {
                        inResults = true;
                        continue;
                    }
                    if (!inResults || (columns = line.split(" ")).length != 2) continue;
                    FontAnalysisItem font = new FontAnalysisItem();
                    String name = columns[0];
                    String[] nameParts = name.split("\\+");
                    if (nameParts.length > 1) {
                        name = nameParts[1];
                        font.setSubSet(true);
                    }
                    font.setName(name);
                    font.setEmbedded(false);
                    if (columns[1].equals("EM") || columns[1].equals("SU")) {
                        font.setEmbedded(true);
                    }
                    result.add(font);
                }
                baos.close();
                Object object = result;
                return object;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Ghostscript.deleteInstance();
        }
    }
}

