/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.gs;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xbib.graphics.gs.GhostscriptLibrary;
import org.xbib.graphics.gs.GhostscriptLibraryLoader;
import org.xbib.graphics.gs.GhostscriptRevision;
import org.xbib.graphics.gs.NullOutputStream;

public class Ghostscript {
    private static final Logger logger = LogManager.getLogger((String)Ghostscript.class.getName());
    public static final String VERSION_PARAMETER = "org.xbib.graphics.gs.version";
    public static final String ENCODING_PARAMETER = "org.xbib.graphics.gs.encoding";
    private static Ghostscript instance;
    protected static GhostscriptLibrary libraryInstance;
    protected static GhostscriptLibrary.gs_main_instance.ByReference nativeInstanceByRef;
    protected static InputStream stdIn;
    protected static OutputStream stdOut;
    protected static OutputStream stdErr;
    protected static String tmpDir;

    protected Ghostscript() {
    }

    public static synchronized Ghostscript getInstance() throws IOException {
        tmpDir = System.getenv("TMPDIR");
        if (tmpDir != null && new File(tmpDir).mkdirs()) {
            logger.info("tmp dir " + tmpDir + " created");
        }
        if (instance == null) {
            instance = new Ghostscript();
        }
        Ghostscript.getGhostscriptLibrary();
        Ghostscript.getNativeInstanceByRef();
        return instance;
    }

    public static synchronized GhostscriptLibrary getGhostscriptLibrary() {
        if (libraryInstance == null) {
            String version = System.getProperty(VERSION_PARAMETER, "9.21");
            libraryInstance = GhostscriptLibraryLoader.loadLibrary(version);
        }
        return libraryInstance;
    }

    public static synchronized GhostscriptLibrary.gs_main_instance.ByReference getNativeInstanceByRef() throws IOException {
        int result;
        if (nativeInstanceByRef == null && (result = libraryInstance.gsapi_new_instance((nativeInstanceByRef = new GhostscriptLibrary.gs_main_instance.ByReference()).getPointer(), null)) != 0) {
            nativeInstanceByRef = null;
            throw new IOException("can not get Ghostscript interpreter instance, error code " + result);
        }
        return nativeInstanceByRef;
    }

    public static synchronized void deleteInstance() throws IOException {
        if (instance != null) {
            instance = null;
            if (tmpDir != null) {
                Ghostscript.deleteGs(tmpDir);
            }
        }
        if (libraryInstance != null) {
            libraryInstance.gsapi_delete_instance(nativeInstanceByRef.getValue());
            libraryInstance = null;
        }
        if (nativeInstanceByRef != null) {
            nativeInstanceByRef = null;
        }
    }

    public static GhostscriptRevision getRevision() {
        GhostscriptLibrary.gsapi_revision_s revision = new GhostscriptLibrary.gsapi_revision_s();
        libraryInstance.gsapi_revision(revision, revision.size());
        GhostscriptRevision result = new GhostscriptRevision();
        result.setProduct(revision.product);
        result.setCopyright(revision.copyright);
        result.setNumber(Float.toString(revision.revision.floatValue() / 100.0f));
        result.setRevisionDate(LocalDate.parse(revision.revisiondate.toString(), DateTimeFormatter.ofPattern("yyyyMMdd")));
        return result;
    }

    public synchronized OutputStream getStdErr() {
        return stdErr;
    }

    public synchronized void setStdErr(OutputStream stdErr) {
        Ghostscript.stdErr = stdErr;
    }

    public synchronized OutputStream getStdOut() {
        return stdOut;
    }

    public synchronized void setStdOut(OutputStream stdOut) {
        Ghostscript.stdOut = stdOut;
    }

    public synchronized InputStream getStdIn() {
        return stdIn;
    }

    public synchronized void setStdIn(InputStream stdIn) {
        Ghostscript.stdIn = stdIn;
    }

    public void initialize(String[] args) throws IOException {
        if (libraryInstance == null || nativeInstanceByRef == null) {
            return;
        }
        GhostscriptLibrary.stdin_fn stdinCallback = null;
        if (this.getStdIn() != null) {
            stdinCallback = (caller_handle, buf, len) -> {
                String encoding = System.getProperty(ENCODING_PARAMETER, "UTF-8");
                try {
                    byte[] buffer = new byte[1024];
                    int read = this.getStdIn().read(buffer);
                    if (read != -1) {
                        buf.setString(0L, new String(buffer, 0, read, encoding));
                        return read;
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                return 0;
            };
        }
        if (this.getStdOut() == null) {
            this.setStdOut(new NullOutputStream());
        }
        GhostscriptLibrary.stdout_fn stdoutCallback = (caller_handle, str, len) -> {
            try {
                this.getStdOut().write(str.getBytes(), 0, len);
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            return len;
        };
        if (this.getStdErr() == null) {
            this.setStdErr(new NullOutputStream());
        }
        GhostscriptLibrary.stderr_fn stderrCallback = (caller_handle, str, len) -> {
            try {
                this.getStdErr().write(str.getBytes(), 0, len);
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            return len;
        };
        logger.debug("setting gsapi_set_stdio");
        int result = libraryInstance.gsapi_set_stdio(nativeInstanceByRef.getValue(), stdinCallback, stdoutCallback, stderrCallback);
        if (result != 0) {
            throw new IOException("can not set stdio on Ghostscript interpreter, error code " + result);
        }
        this.initializeDisplay();
        logger.debug("gsapi_init_with_args = " + (args != null ? Arrays.asList(args) : "null"));
        result = libraryInstance.gsapi_init_with_args(nativeInstanceByRef.getValue(), args != null ? args.length : 0, args);
        logger.debug("gsapi_init_with_args result = " + result);
        if (result == -101) {
            result = 0;
        }
        if (result == 0) {
            return;
        }
        if (result < 0) {
            this.exit();
            throw new IOException("can not initialize Ghostscript interpreter, error code " + result);
        }
    }

    protected void initializeDisplay() throws IOException {
    }

    public void exit() throws IOException {
        if (libraryInstance == null || nativeInstanceByRef == null) {
            return;
        }
        Pointer pointer = nativeInstanceByRef.getValue();
        if (pointer != null) {
            logger.info("gsapi_exit " + pointer);
            int result = libraryInstance.gsapi_exit(pointer);
            if (result != 0) {
                throw new IOException("can not exit Ghostscript interpreter, error code " + result);
            }
        }
    }

    public void runString(String string) throws IOException {
        String[] slices;
        if (libraryInstance == null || nativeInstanceByRef == null) {
            return;
        }
        IntByReference exitCode = new IntByReference();
        libraryInstance.gsapi_run_string_begin(nativeInstanceByRef.getValue(), 0, exitCode);
        if (exitCode.getValue() != 0) {
            throw new IOException("can not run command on Ghostscript interpreter. gsapi_run_string_begin failed with error code " + exitCode.getValue());
        }
        for (String slice1 : slices = string.split("\n")) {
            String slice = slice1 + "\n";
            libraryInstance.gsapi_run_string_continue(nativeInstanceByRef.getValue(), slice, slice.length(), 0, exitCode);
            if (exitCode.getValue() == 0) continue;
            throw new IOException("can not run command on Ghostscript interpreter. gsapi_run_string_continue failed with error code " + exitCode.getValue());
        }
        libraryInstance.gsapi_run_string_end(nativeInstanceByRef.getValue(), 0, exitCode);
        if (exitCode.getValue() != 0) {
            throw new IOException("can not run command on Ghostscript interpreter. gsapi_run_string_end failed with error code " + exitCode.getValue());
        }
    }

    public void runFile(String fileName) throws IOException {
        if (libraryInstance == null || nativeInstanceByRef == null) {
            return;
        }
        IntByReference exitCode = new IntByReference();
        libraryInstance.gsapi_run_file(nativeInstanceByRef.getValue(), fileName, 0, exitCode);
        if (exitCode.getValue() != 0) {
            throw new IOException("can not run file on Ghostscript interpreter, error code " + exitCode.getValue());
        }
    }

    private static void deleteGs(String path) throws IOException {
        logger.info("delete gs_* in " + path);
        try {
            Files.walkFileTree(Paths.get(path, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.startsWith("gs_")) {
                        Files.delete(file);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (NoSuchFileException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    static interface ErrorCodes {
        public static final int gs_error_ok = 0;
        public static final int gs_error_unknownerror = -1;
        public static final int gs_error_dictfull = -2;
        public static final int gs_error_dictstackoverflow = -3;
        public static final int gs_error_dictstackunderflow = -4;
        public static final int gs_error_execstackoverflow = -5;
        public static final int gs_error_interrupt = -6;
        public static final int gs_error_invalidaccess = -7;
        public static final int gs_error_invalidexit = -8;
        public static final int gs_error_invalidfileaccess = -9;
        public static final int gs_error_invalidfont = -10;
        public static final int gs_error_invalidrestore = -11;
        public static final int gs_error_ioerror = -12;
        public static final int gs_error_limitcheck = -13;
        public static final int gs_error_nocurrentpoint = -14;
        public static final int gs_error_rangecheck = -15;
        public static final int gs_error_stackoverflow = -16;
        public static final int gs_error_stackunderflow = -17;
        public static final int gs_error_syntaxerror = -18;
        public static final int gs_error_timeout = -19;
        public static final int gs_error_typecheck = -20;
        public static final int gs_error_undefined = -21;
        public static final int gs_error_undefinedfilename = -22;
        public static final int gs_error_undefinedresult = -23;
        public static final int gs_error_unmatchedmark = -24;
        public static final int gs_error_VMerror = -25;
        public static final int gs_error_configurationerror = -26;
        public static final int gs_error_undefinedresource = -27;
        public static final int gs_error_unregistered = -28;
        public static final int gs_error_invalidcontext = -29;
        public static final int gs_error_invalidid = -30;
        public static final int gs_error_hit_detected = -99;
        public static final int gs_error_Fatal = -100;
        public static final int gs_error_Quit = -101;
        public static final int gs_error_InterpreterExit = -102;
        public static final int gs_error_Remap_Color = -103;
        public static final int gs_error_ExecStackUnderflow = -104;
        public static final int gs_error_VMreclaim = -105;
        public static final int gs_error_NeedInput = -106;
        public static final int gs_error_Info = -110;
        public static final int gs_error_handled = -111;
    }
}

