/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.gs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xbib.graphics.gs.Ghostscript;

public class GhostscriptLoggerOutputStream
extends OutputStream {
    private static final String LOGGER_NAME = Ghostscript.class.getName();
    private static final int LINE_END = 10;
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private Logger logger = LogManager.getLogger((String)LOGGER_NAME);
    private Level level;

    public GhostscriptLoggerOutputStream(Level level) {
        this.baos = new ByteArrayOutputStream();
        this.level = level;
    }

    @Override
    public void write(int b) throws IOException {
        if (b == 10) {
            this.logger.log(this.level, this.baos.toString());
            this.baos.reset();
        } else {
            this.baos.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        for (int i = off; i < off + len; ++i) {
            this.write(b[i]);
        }
    }
}

