/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.gs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xbib.graphics.gs.Ghostscript;
import org.xbib.graphics.gs.PaperSize;
import org.xbib.io.LoggingOutputStream;

public class PDFConverter {
    private static final Logger logger = LogManager.getLogger((String)PDFConverter.class.getName());
    public static final int OPTION_AUTOROTATEPAGES_NONE = 0;
    public static final int OPTION_AUTOROTATEPAGES_ALL = 1;
    public static final int OPTION_AUTOROTATEPAGES_PAGEBYPAGE = 2;
    public static final int OPTION_AUTOROTATEPAGES_OFF = 3;
    public static final int OPTION_PROCESSCOLORMODEL_RGB = 0;
    public static final int OPTION_PROCESSCOLORMODEL_GRAY = 1;
    public static final int OPTION_PROCESSCOLORMODEL_CMYK = 2;
    public static final int OPTION_PDFSETTINGS_DEFAULT = 0;
    public static final int OPTION_PDFSETTINGS_SCREEN = 1;
    public static final int OPTION_PDFSETTINGS_EBOOK = 2;
    public static final int OPTION_PDFSETTINGS_PRINTER = 3;
    public static final int OPTION_PDFSETTINGS_PREPRESS = 4;
    private int autoRotatePages = 3;
    private int processColorModel;
    private int pdfsettings;
    private String compatibilityLevel = "1.4";
    private boolean pdfx = false;
    private PaperSize paperSize = PaperSize.A4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void convert(InputStream inputStream, OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            return;
        }
        Ghostscript gs = Ghostscript.getInstance();
        LinkedList<String> gsArgs = new LinkedList<String>();
        gsArgs.add("-ps2pdf");
        gsArgs.add("-dNOPAUSE");
        gsArgs.add("-dBATCH");
        gsArgs.add("-dSAFER");
        switch (this.autoRotatePages) {
            case 0: {
                gsArgs.add("-dAutoRotatePages=/None");
                break;
            }
            case 1: {
                gsArgs.add("-dAutoRotatePages=/All");
                break;
            }
            case 2: {
                gsArgs.add("-dAutoRotatePages=/PageByPage");
                break;
            }
        }
        switch (this.processColorModel) {
            case 2: {
                gsArgs.add("-dProcessColorModel=/DeviceCMYK");
                break;
            }
            case 1: {
                gsArgs.add("-dProcessColorModel=/DeviceGray");
                break;
            }
            default: {
                gsArgs.add("-dProcessColorModel=/DeviceRGB");
            }
        }
        switch (this.pdfsettings) {
            case 2: {
                gsArgs.add("-dPDFSETTINGS=/ebook");
                break;
            }
            case 1: {
                gsArgs.add("-dPDFSETTINGS=/screen");
                break;
            }
            case 3: {
                gsArgs.add("-dPDFSETTINGS=/printer");
                break;
            }
            case 4: {
                gsArgs.add("-dPDFSETTINGS=/prepress");
                break;
            }
            default: {
                gsArgs.add("-dPDFSETTINGS=/default");
            }
        }
        gsArgs.add("-dCompatibilityLevel=" + this.compatibilityLevel);
        gsArgs.add("-dPDFX=" + this.pdfx);
        gsArgs.add("-dDEVICEWIDTHPOINTS=" + this.paperSize.getWidth());
        gsArgs.add("-dDEVICEHEIGHTPOINTS=" + this.paperSize.getHeight());
        gsArgs.add("-sDEVICE=pdfwrite");
        Path output = Files.createTempFile("pdf", "pdf", new FileAttribute[0]);
        gsArgs.add("-sOutputFile=" + output.toAbsolutePath().toString());
        gsArgs.add("-f");
        gsArgs.add("-");
        try {
            gs.setStdIn(inputStream);
            gs.setStdOut((OutputStream)new LoggingOutputStream(logger, Level.ALL));
            gs.setStdErr((OutputStream)new LoggingOutputStream(logger, Level.ALL));
            gs.initialize(gsArgs.toArray(new String[gsArgs.size()]));
            Files.copy(output.toAbsolutePath(), outputStream);
        }
        finally {
            Ghostscript.deleteInstance();
            Files.delete(output);
        }
    }

    public int getAutoRotatePages() {
        return this.autoRotatePages;
    }

    public void setAutoRotatePages(int autoRotatePages) {
        this.autoRotatePages = autoRotatePages;
    }

    public int getProcessColorModel() {
        return this.processColorModel;
    }

    public void setProcessColorModel(int processColorModel) {
        this.processColorModel = processColorModel;
    }

    public String getCompatibilityLevel() {
        return this.compatibilityLevel;
    }

    public void setCompatibilityLevel(String compatibilityLevel) {
        this.compatibilityLevel = compatibilityLevel;
    }

    public int getPDFSettings() {
        return this.pdfsettings;
    }

    public void setPDFSettings(int PDFSettings) {
        this.pdfsettings = PDFSettings;
    }

    public boolean isPDFX() {
        return this.pdfx;
    }

    public void setPDFX(boolean b) {
        this.pdfx = b;
    }

    public PaperSize getPaperSize() {
        return this.paperSize;
    }

    public void setPaperSize(PaperSize paperSize) {
        this.paperSize = paperSize;
    }

    public void setPaperSize(String paperSizeName) {
        this.setPaperSize(PaperSize.valueOf(paperSizeName.toUpperCase()));
    }
}

