/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.gs;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.xbib.graphics.gs.Ghostscript;
import org.xbib.io.LoggingOutputStream;

public class PDFRasterizer {
    private static final Logger logger = LogManager.getLogger((String)PDFRasterizer.class.getName());
    private final String creator;
    private final String author;
    private final String subject;

    public PDFRasterizer(String subject) {
        this("org.xbib.graphics.gs/1.0.6", "J\u00f6rg Prante <prante@hbz-nrw.de>", subject);
    }

    public PDFRasterizer(String creator, String author, String subject) {
        this.creator = creator;
        this.author = author;
        this.subject = subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void convert(Path source, Path target) throws IOException {
        logger.info("convert source=" + source.toAbsolutePath() + " target=" + target);
        if (!Files.exists(source.toAbsolutePath(), new LinkOption[0])) {
            throw new FileNotFoundException(source.toString());
        }
        if (!Files.isReadable(source.toAbsolutePath())) {
            throw new IOException("unable to read " + source.toString());
        }
        Path tmp = Files.createTempDirectory("pdf-rasterize", new FileAttribute[0]);
        try {
            this.pdfToImage(source.toAbsolutePath(), tmp);
            Path tmpTarget = tmp.resolve(target.getFileName());
            this.mergeImagesToPDF(tmp, tmpTarget);
            this.scalePDF(tmpTarget, target);
        }
        finally {
            this.delete(tmp);
            logger.info("convert source=" + source.toAbsolutePath() + " done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void screenConvert(Path source, Path target) throws IOException {
        logger.info("convert source=" + source.toAbsolutePath() + " target=" + target);
        if (!Files.exists(source.toAbsolutePath(), new LinkOption[0])) {
            throw new FileNotFoundException(source.toString());
        }
        if (!Files.isReadable(source.toAbsolutePath())) {
            throw new IOException("unable to read " + source.toString());
        }
        Path tmp = Files.createTempDirectory("pdf-rasterize", new FileAttribute[0]);
        try {
            this.pdfToGrayScreenImage(source.toAbsolutePath(), tmp);
            Path tmpTarget = tmp.resolve(target.getFileName());
            this.mergeImagesToPDF(tmp, tmpTarget);
            this.scalePDF(tmpTarget, target);
        }
        finally {
            this.delete(tmp);
            logger.info("convert source=" + source.toAbsolutePath() + " done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void pdfToGrayScreenImage(Path source, Path target) throws IOException {
        logger.info("pdfToImage source=" + source + " target=" + target);
        if (!Files.exists(source.toAbsolutePath(), new LinkOption[0])) {
            throw new FileNotFoundException(source.toString());
        }
        if (!Files.isReadable(source.toAbsolutePath())) {
            throw new IOException("unable to read " + source.toString());
        }
        try {
            Ghostscript gs = Ghostscript.getInstance();
            LinkedList<String> gsArgs = new LinkedList<String>();
            gsArgs.add("-dNOPAUSE");
            gsArgs.add("-dBATCH");
            gsArgs.add("-dUseCropBox");
            gsArgs.add("-sDEVICE=pnggray");
            gsArgs.add("-r72");
            gsArgs.add("-sOutputFile=" + target.resolve("screen-gray-pdf-%05d.png"));
            gsArgs.add("-f");
            gsArgs.add(source.toString());
            logger.info("pdfToImage args=" + gsArgs);
            gs.setStdIn(null);
            gs.setStdOut((OutputStream)new LoggingOutputStream(logger, Level.ALL));
            gs.setStdErr((OutputStream)new LoggingOutputStream(logger, Level.ALL));
            gs.initialize(gsArgs.toArray(new String[gsArgs.size()]));
            gs.exit();
        }
        finally {
            Ghostscript.deleteInstance();
            logger.info("pdfToImage done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void pdfToImage(Path source, Path target) throws IOException {
        logger.info("pdfToImage source=" + source + " target=" + target);
        try {
            Ghostscript gs = Ghostscript.getInstance();
            LinkedList<String> gsArgs = new LinkedList<String>();
            gsArgs.add("-dNOPAUSE");
            gsArgs.add("-dBATCH");
            gsArgs.add("-dQUIET");
            gsArgs.add("-dINTERPOLATE");
            gsArgs.add("-dUseCropBox");
            gsArgs.add("-sDEVICE=png16m");
            gsArgs.add("-r300");
            gsArgs.add("-sOutputFile=" + target.resolve("pdf-%05d.png"));
            gsArgs.add("-dNumRenderingThreads=" + Runtime.getRuntime().availableProcessors() / 2);
            gsArgs.add("-dMaxBitmap=100000000");
            gsArgs.add("-c");
            gsArgs.add("100000000 setvmthreshold");
            gsArgs.add("-f");
            gsArgs.add(source.toString());
            logger.info("pdfToImage args=" + gsArgs);
            gs.setStdIn(null);
            gs.setStdOut((OutputStream)new LoggingOutputStream(logger, Level.ALL));
            gs.setStdErr((OutputStream)new LoggingOutputStream(logger, Level.ALL));
            gs.initialize(gsArgs.toArray(new String[gsArgs.size()]));
            gs.exit();
        }
        finally {
            Ghostscript.deleteInstance();
            logger.info("pdfToImage done");
        }
    }

    public synchronized int mergeImagesToPDF(Path sourceDir, Path target) throws IOException {
        logger.info("mergeImagesToPDF: source=" + sourceDir + " target=" + target);
        List entries = Files.list(sourceDir).sorted().collect(Collectors.toList());
        int pagecount = 0;
        ArrayList<PDDocument> coverPageDocs = new ArrayList<PDDocument>();
        try (PDDocument pdDocument = new PDDocument();){
            pdDocument.getDocumentInformation().setTitle(target.getFileName().toString());
            pdDocument.getDocumentInformation().setCreationDate(Calendar.getInstance());
            pdDocument.getDocumentInformation().setCreator(this.creator);
            pdDocument.getDocumentInformation().setSubject(this.subject);
            pdDocument.getDocumentInformation().setAuthor(this.author);
            for (Path path : entries) {
                if (path.toString().endsWith(".pdf")) {
                    logger.info("found pdf " + path);
                    PDDocument doc = PDDocument.load((File)path.toFile());
                    for (int i = 0; i < doc.getNumberOfPages(); ++i) {
                        PDPage page = doc.getPage(i);
                        PDPage newPage = pdDocument.importPage(page);
                        newPage.setResources(page.getResources());
                        newPage.setCropBox(page.getCropBox());
                        newPage.setMediaBox(page.getMediaBox());
                        newPage.setRotation(page.getRotation());
                        ++pagecount;
                    }
                    coverPageDocs.add(doc);
                    continue;
                }
                if (!path.toString().endsWith(".png")) continue;
                logger.info("found image " + path);
                BufferedImage bufferedImage = ImageIO.read(path.toFile());
                PDPage page = new PDPage(new PDRectangle((float)bufferedImage.getWidth(), (float)bufferedImage.getHeight()));
                pdDocument.addPage(page);
                PDImageXObject pdImageXObject = LosslessFactory.createFromImage((PDDocument)pdDocument, (BufferedImage)bufferedImage);
                PDPageContentStream pdPageContentStream = new PDPageContentStream(pdDocument, page, PDPageContentStream.AppendMode.APPEND, true);
                pdPageContentStream.drawImage(pdImageXObject, 0.0f, 0.0f);
                pdPageContentStream.close();
                ++pagecount;
            }
            pdDocument.save(target.toFile());
            pdDocument.close();
        }
        for (PDDocument pd : coverPageDocs) {
            pd.close();
        }
        logger.info("mergeImagesToPDF: done, " + pagecount + " pages");
        return pagecount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void scalePDF(Path source, Path target) throws IOException {
        logger.info("scalePDF: source = " + source + " target = " + target);
        try {
            Ghostscript gs = Ghostscript.getInstance();
            LinkedList<String> gsArgs = new LinkedList<String>();
            gsArgs.add("-dNOPAUSE");
            gsArgs.add("-dBATCH");
            gsArgs.add("-dQUIET");
            gsArgs.add("-sDEVICE=pdfwrite");
            gsArgs.add("-dPDFSETTINGS=/printer");
            gsArgs.add("-sPAPERSIZE=a4");
            gsArgs.add("-dPDFFitPage");
            gsArgs.add("-dAutoRotatePages=/PageByPage");
            gsArgs.add("-dCompatibilityLevel=1.4");
            gsArgs.add("-sOutputFile=" + target.toString());
            gsArgs.add(source.toString());
            gs.setStdIn(null);
            gs.initialize(gsArgs.toArray(new String[gsArgs.size()]));
            gs.exit();
        }
        finally {
            Ghostscript.deleteInstance();
            logger.info("scalePDF: done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toPDFA(Path source, Path target) throws IOException {
        Path iccPath = Files.createTempFile("srgb", ".icc", new FileAttribute[0]);
        Path pdfapsPathTmp = Files.createTempFile("PDFA_def", ".tmp", new FileAttribute[0]);
        Path pdfapsPath = Files.createTempFile("PDFA_def", ".ps", new FileAttribute[0]);
        try {
            Ghostscript gs = Ghostscript.getInstance();
            Files.copy(this.getClass().getResourceAsStream("/iccprofiles/srgb.icc"), iccPath, StandardCopyOption.REPLACE_EXISTING);
            Files.copy(this.getClass().getResourceAsStream("/lib/PDFA_def.ps"), pdfapsPathTmp, StandardCopyOption.REPLACE_EXISTING);
            this.copyAndReplace(pdfapsPathTmp, pdfapsPath, "srgb.icc", iccPath.toAbsolutePath().toString());
            LinkedList<String> gsArgs = new LinkedList<String>();
            gsArgs.add("-E");
            gsArgs.add("-dNOPAUSE");
            gsArgs.add("-dBATCH");
            gsArgs.add("-dQUIET");
            gsArgs.add("-dNOSAFER");
            gsArgs.add("-dPDFA=2");
            gsArgs.add("-sColorConversionStrategy=/sRGB");
            gsArgs.add("-sOutputICCProfile=" + iccPath.toAbsolutePath().toString());
            gsArgs.add("-sDEVICE=pdfwrite");
            gsArgs.add("-dPDFSETTINGS=/printer");
            gsArgs.add("-sPAPERSIZE=a4");
            gsArgs.add("-dPDFFitPage");
            gsArgs.add("-dAutoRotatePages=/PageByPage");
            gsArgs.add("-sOutputFile=" + target.toString());
            gsArgs.add(pdfapsPath.toAbsolutePath().toString());
            gsArgs.add(source.toString());
            gs.setStdIn(null);
            gs.initialize(gsArgs.toArray(new String[gsArgs.size()]));
            gs.exit();
        }
        finally {
            Ghostscript.deleteInstance();
            this.delete(pdfapsPathTmp);
            this.delete(pdfapsPath);
            this.delete(iccPath);
        }
    }

    private void copyAndReplace(Path source, Path target, String from, String to) throws IOException {
        try (BufferedReader br = Files.newBufferedReader(source);
             BufferedWriter bw = Files.newBufferedWriter(target, new OpenOption[0]);){
            String line;
            while ((line = br.readLine()) != null) {
                line = line.replaceAll(from, to);
                bw.write(line + "\n");
            }
        }
    }

    private void delete(Path path) throws IOException {
        logger.info("delete " + path);
        try {
            Files.walkFileTree(path.toAbsolutePath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (NoSuchFileException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

