/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.gs;

import java.nio.file.Path;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xbib.graphics.gs.PDFRasterizer;

public class PDFRasterizerService {
    private static final Logger logger = LogManager.getLogger((String)PDFRasterizerService.class.getName());

    public void convert(String subject, Path source, Path target) throws InterruptedException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        CountDownLatch latch = new CountDownLatch(1);
        executor.execute(() -> {
            PDFRasterizer pdfRasterizer = new PDFRasterizer(subject);
            try {
                pdfRasterizer.convert(source, target);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                latch.countDown();
            }
        });
        latch.await();
    }
}

