/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.net.path;

import java.nio.charset.Charset;
import org.xbib.net.Parameter;
import org.xbib.net.ParameterBuilder;
import org.xbib.net.PathNormalizer;

public class PathDecoder {
    private final String path;
    private final String query;
    private final Charset charset;
    private final ParameterBuilder params;

    public PathDecoder(String pathAndQuery, Charset charset) {
        this(pathAndQuery, null, charset);
    }

    public PathDecoder(String pathAndQuery, String queryString, Charset charset) {
        this.charset = charset;
        int pos = pathAndQuery.indexOf(63);
        String path = pos > 0 ? pathAndQuery.substring(0, pos) : pathAndQuery;
        this.query = pos > 0 ? pathAndQuery.substring(pos + 1) : null;
        this.path = PathNormalizer.normalize((String)path);
        this.params = Parameter.builder().domain(Parameter.Domain.PATH).enablePercentDecoding();
        if (this.query != null) {
            this.params.add(this.query, charset);
        }
        if (queryString != null) {
            this.params.add(queryString, charset);
        }
    }

    public void parse(String queryString) {
        this.params.add(queryString, this.charset);
    }

    public String path() {
        return this.path;
    }

    public String query() {
        return this.query;
    }

    public Parameter getParameter() {
        return this.params.build();
    }
}

