/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.net.path.simple;

import java.util.Objects;
import java.util.regex.Pattern;

public class Path {
    static final Pattern VARIABLE_PATTERN = Pattern.compile("\\{[^/]+?}");
    static final String CATCH_ALL = "**";
    private final String pattern;
    private int uriVars;
    private int singleWildcards;
    private int doubleWildcards;
    private boolean catchAllPattern;
    private boolean prefixPattern;
    private Integer length;

    public Path(String pattern) {
        this.pattern = pattern;
        if (this.pattern != null) {
            this.initCounters();
            this.catchAllPattern = this.pattern.equals(CATCH_ALL);
            boolean bl = this.prefixPattern = !this.catchAllPattern && this.pattern.endsWith(CATCH_ALL);
        }
        if (this.uriVars == 0) {
            this.length = this.pattern != null ? this.pattern.length() : 0;
        }
    }

    public static Path of(String string) {
        return new Path(string);
    }

    public String getPattern() {
        return this.pattern;
    }

    public int getUriVars() {
        return this.uriVars;
    }

    public int getSingleWildcards() {
        return this.singleWildcards;
    }

    public int getDoubleWildcards() {
        return this.doubleWildcards;
    }

    public boolean isLeastSpecific() {
        return this.pattern == null || this.catchAllPattern;
    }

    public boolean isPrefixPattern() {
        return this.prefixPattern;
    }

    public int getTotalCount() {
        return this.uriVars + this.singleWildcards + 2 * this.doubleWildcards;
    }

    public int getLength() {
        if (this.length == null) {
            this.length = VARIABLE_PATTERN.matcher(this.pattern).replaceAll("#").length();
        }
        return this.length;
    }

    public boolean isCatchAllPattern() {
        return this.catchAllPattern;
    }

    public boolean isWildCard() {
        return this.singleWildcards > 0 || this.doubleWildcards > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Path that = (Path)o;
        return this.uriVars == that.uriVars && this.singleWildcards == that.singleWildcards && this.doubleWildcards == that.doubleWildcards && this.catchAllPattern == that.catchAllPattern && this.prefixPattern == that.prefixPattern && Objects.equals(this.pattern, that.pattern) && Objects.equals(this.length, that.length);
    }

    public int hashCode() {
        return Objects.hash(this.pattern, this.uriVars, this.singleWildcards, this.doubleWildcards, this.catchAllPattern, this.prefixPattern, this.length);
    }

    private void initCounters() {
        int pos = 0;
        int len = this.pattern.length();
        while (pos < len) {
            if (this.pattern.charAt(pos) == '{') {
                ++this.uriVars;
                ++pos;
                continue;
            }
            if (this.pattern.charAt(pos) == '*') {
                if (pos + 1 < len && this.pattern.charAt(pos + 1) == '*') {
                    ++this.doubleWildcards;
                    pos += 2;
                    continue;
                }
                if (pos > 0 && (this.pattern.charAt(pos - 1) != '.' || this.pattern.charAt(pos) != '*')) {
                    ++this.singleWildcards;
                    ++pos;
                    continue;
                }
                ++pos;
                continue;
            }
            ++pos;
        }
    }
}

