/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.net.path.simple;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.xbib.net.Parameter;
import org.xbib.net.ParameterBuilder;
import org.xbib.net.path.simple.PathComparator;
import org.xbib.net.path.simple.PathStringMatcher;

public class PathMatcher {
    private static final String DEFAULT_PATH_SEPARATOR = "/";
    private String pathSeparator;
    private String endsOnWildCard;
    private String endsOnDoubleWildCard;
    private boolean caseSensitive;
    private boolean trimTokens;

    public PathMatcher() {
        this(DEFAULT_PATH_SEPARATOR);
    }

    public PathMatcher(String pathSeparator) {
        this.pathSeparator = pathSeparator;
        this.update();
    }

    public void setPathSeparator(String pathSeparator) {
        this.pathSeparator = pathSeparator;
        this.update();
    }

    private void update() {
        this.endsOnWildCard = this.pathSeparator + "*";
        this.endsOnDoubleWildCard = this.pathSeparator + "**";
        this.caseSensitive = true;
        this.trimTokens = true;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setTrimTokens(boolean trimTokens) {
        this.trimTokens = trimTokens;
    }

    public Parameter extractUriTemplateVariables(String pattern, String path) {
        ParameterBuilder uriParameters = Parameter.builder().domain(Parameter.Domain.PATH);
        if (!this.doMatch(pattern, path, true, uriParameters)) {
            throw new IllegalStateException("Pattern \"" + pattern + "\" is not a match for \"" + path + "\"");
        }
        return uriParameters.build();
    }

    public PathComparator getPatternComparator(String path) {
        return new PathComparator(path);
    }

    public boolean match(String pattern, String path) {
        return this.doMatch(pattern, path, true, null);
    }

    public boolean matchStart(String pattern, String path) {
        return this.doMatch(pattern, path, false, null);
    }

    public String extractPathWithinPattern(String pattern, String path) {
        List<String> patternParts = PathMatcher.tokenize(pattern, this.pathSeparator, this.trimTokens);
        List<String> pathParts = PathMatcher.tokenize(path, this.pathSeparator, this.trimTokens);
        StringBuilder sb = new StringBuilder();
        boolean pathStarted = false;
        for (int segment = 0; segment < patternParts.size(); ++segment) {
            String patternPart = patternParts.get(segment);
            if (patternPart.indexOf(42) <= -1 && patternPart.indexOf(63) <= -1) continue;
            while (segment < pathParts.size()) {
                if (pathStarted || segment == 0 && !pattern.startsWith(this.pathSeparator)) {
                    sb.append(this.pathSeparator);
                }
                sb.append(pathParts.get(segment));
                pathStarted = true;
                ++segment;
            }
        }
        return sb.toString();
    }

    public String combine(String pattern1, String pattern2) {
        boolean ext2All;
        boolean pattern1ContainsUriVar;
        if (PathMatcher.hasNotText(pattern1) && PathMatcher.hasNotText(pattern2)) {
            return "";
        }
        if (PathMatcher.hasNotText(pattern1)) {
            return pattern2;
        }
        if (PathMatcher.hasNotText(pattern2)) {
            return pattern1;
        }
        boolean bl = pattern1ContainsUriVar = pattern1.indexOf(123) != -1;
        if (!pattern1.equals(pattern2) && !pattern1ContainsUriVar && this.match(pattern1, pattern2)) {
            return pattern2;
        }
        if (pattern1.endsWith(this.endsOnWildCard)) {
            return this.concat(pattern1.substring(0, pattern1.length() - 2), pattern2);
        }
        if (pattern1.endsWith(this.endsOnDoubleWildCard)) {
            return this.concat(pattern1, pattern2);
        }
        int starDotPos1 = pattern1.indexOf("*.");
        if (pattern1ContainsUriVar || starDotPos1 == -1 || this.pathSeparator.equals(".")) {
            return this.concat(pattern1, pattern2);
        }
        String ext1 = pattern1.substring(starDotPos1 + 1);
        int dotPos2 = pattern2.indexOf(46);
        String file2 = dotPos2 == -1 ? pattern2 : pattern2.substring(0, dotPos2);
        String ext2 = dotPos2 == -1 ? "" : pattern2.substring(dotPos2);
        boolean ext1All = ext1.equals(".*") || ext1.equals("");
        boolean bl2 = ext2All = ext2.equals(".*") || ext2.equals("");
        if (!ext1All && !ext2All) {
            throw new IllegalArgumentException("Cannot combine patterns: " + pattern1 + " vs " + pattern2);
        }
        String ext = ext1All ? ext2 : ext1;
        return file2 + ext;
    }

    private static boolean hasNotText(CharSequence str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private String concat(String path1, String path2) {
        boolean path1EndsWithSeparator = path1.endsWith(this.pathSeparator);
        boolean path2StartsWithSeparator = path2.startsWith(this.pathSeparator);
        if (path1EndsWithSeparator && path2StartsWithSeparator) {
            return path1 + path2.substring(1);
        }
        if (path1EndsWithSeparator || path2StartsWithSeparator) {
            return path1 + path2;
        }
        return path1 + this.pathSeparator + path2;
    }

    private boolean doMatch(String pattern, String path, boolean fullMatch, ParameterBuilder queryParameters) {
        String pattDir;
        String patternString;
        int pathIdxStart;
        if (path.startsWith(this.pathSeparator) != pattern.startsWith(this.pathSeparator)) {
            return false;
        }
        List<String> patternElements = PathMatcher.tokenize(pattern, this.pathSeparator, this.trimTokens);
        List<String> pathElements = PathMatcher.tokenize(path, this.pathSeparator, this.trimTokens);
        int pattIdxStart = 0;
        int pattIdxEnd = patternElements.size() - 1;
        int pathIdxEnd = pathElements.size() - 1;
        for (pathIdxStart = 0; pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !"**".equals(patternString = patternElements.get(pattIdxStart)); ++pattIdxStart, ++pathIdxStart) {
            if (this.matchStrings(patternString, pathElements.get(pathIdxStart), queryParameters)) continue;
            return false;
        }
        if (pathIdxStart > pathIdxEnd) {
            if (pattIdxStart > pattIdxEnd) {
                return pattern.endsWith(this.pathSeparator) == path.endsWith(this.pathSeparator);
            }
            if (!fullMatch) {
                return true;
            }
            if (pattIdxStart == pattIdxEnd && patternElements.get(pattIdxStart).equals("*") && path.endsWith(this.pathSeparator)) {
                return true;
            }
            for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
                if (patternElements.get(i).equals("**")) continue;
                return false;
            }
            return true;
        }
        if (pattIdxStart > pattIdxEnd) {
            return false;
        }
        if (!fullMatch && "**".equals(patternElements.get(pattIdxStart))) {
            return true;
        }
        while (pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !(pattDir = patternElements.get(pattIdxEnd)).equals("**")) {
            if (!this.matchStrings(pattDir, pathElements.get(pathIdxEnd), queryParameters)) {
                return false;
            }
            --pattIdxEnd;
            --pathIdxEnd;
        }
        if (pathIdxStart > pathIdxEnd) {
            for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
                if (patternElements.get(i).equals("**")) continue;
                return false;
            }
            return true;
        }
        while (pattIdxStart != pattIdxEnd && pathIdxStart <= pathIdxEnd) {
            int patIdxTmp = -1;
            for (int i = pattIdxStart + 1; i <= pattIdxEnd; ++i) {
                if (!patternElements.get(i).equals("**")) continue;
                patIdxTmp = i;
                break;
            }
            if (patIdxTmp == pattIdxStart + 1) {
                ++pattIdxStart;
                continue;
            }
            int patLength = patIdxTmp - pattIdxStart - 1;
            int strLength = pathIdxEnd - pathIdxStart + 1;
            int foundIdx = -1;
            boolean strLoop = true;
            block6: while (strLoop) {
                for (int i = 0; i <= strLength - patLength; ++i) {
                    for (int j = 0; j < patLength; ++j) {
                        String subStr;
                        String subPat = patternElements.get(pattIdxStart + j + 1);
                        if (!this.matchStrings(subPat, subStr = pathElements.get(pathIdxStart + i + j), queryParameters)) continue;
                        strLoop = false;
                        break;
                    }
                    if (!strLoop) continue block6;
                    foundIdx = pathIdxStart + i;
                }
            }
            if (foundIdx == -1) {
                return false;
            }
            pattIdxStart = patIdxTmp;
            pathIdxStart = foundIdx + patLength;
        }
        for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
            if (patternElements.get(i).equals("**")) continue;
            return false;
        }
        return true;
    }

    public List<String> tokenize(String string) {
        return PathMatcher.tokenize(string, this.pathSeparator, this.trimTokens);
    }

    private static List<String> tokenize(String string, String delimiters, boolean trimTokens) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (string == null) {
            return tokens;
        }
        StringTokenizer st = new StringTokenizer(string, delimiters);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (token.length() <= 0) continue;
            tokens.add(token);
        }
        return tokens;
    }

    private boolean matchStrings(String patternString, String str, ParameterBuilder queryParameters) {
        return new PathStringMatcher(patternString, this.caseSensitive).match(str, queryParameters);
    }
}

