/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.net.path.simple;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xbib.net.Parameter;
import org.xbib.net.ParameterBuilder;
import org.xbib.net.ParameterException;
import org.xbib.net.path.PathResolver;
import org.xbib.net.path.simple.PathMatcher;
import org.xbib.net.util.CharMatcher;

public class PathResolver<T>
implements org.xbib.net.path.PathResolver<T> {
    private static final String PARAMETER_PATH_SEGMENT = "{}";
    private static final Pattern PARAMETER_NAME_PATTERN = Pattern.compile("[a-zA-Z_][a-zA-Z_\\d]*");
    private static final CharMatcher RESERVED_URL_CHARS = CharMatcher.anyOf((CharSequence)":/?#[]{}");
    private final Builder<T> builder;
    private final Map<String, PathResolver<T>> children;

    private PathResolver(Builder<T> builder) {
        this.builder = builder;
        this.children = new LinkedHashMap<String, PathResolver<T>>();
        for (Map.Entry entry : builder.subBuilders.entrySet()) {
            this.children.put(entry.getKey(), new PathResolver(entry.getValue()));
        }
    }

    @Override
    public void resolve(String method, String path, PathResolver.ResultListener<T> resultListener) throws ParameterException {
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(path, "path");
        this.resolve(method, this.builder.pathMatcher.tokenize(path), 0, new ArrayList<String>(), resultListener);
    }

    public String toString() {
        return "PathResolver[builder=" + String.valueOf(this.builder) + ", children=" + String.valueOf(this.children) + "]";
    }

    private void resolve(String method, List<String> pathSegments, int index, List<String> parameters, PathResolver.ResultListener<T> resultListener) throws ParameterException {
        if (index < pathSegments.size()) {
            String segment = pathSegments.get(index);
            PathResolver<T> child = this.children.get(segment);
            if (child != null) {
                child.resolve(method, pathSegments, index + 1, parameters, resultListener);
            }
            if ((child = this.children.get(PARAMETER_PATH_SEGMENT)) != null) {
                parameters.add(segment);
                child.resolve(method, pathSegments, index + 1, parameters, resultListener);
                parameters.remove(parameters.size() - 1);
            }
        } else if (this.builder.infoMap.containsKey(method)) {
            Info info = this.builder.infoMap.get(method);
            ParameterBuilder parameterBuilder = Parameter.builder().domain(Parameter.Domain.PATH).enableSort();
            for (int i = 0; i < info.parameterNames.size(); ++i) {
                parameterBuilder.add(info.parameterNames.get(i), (Object)parameters.get(i));
            }
            resultListener.onResult(new Result(info.value, parameterBuilder.build(), info.method));
        }
    }

    public static <T> Builder<T> builder() {
        return new Builder(true);
    }

    public static <T> Builder<T> builder(boolean throwOnConflict) {
        return new Builder(throwOnConflict);
    }

    public static class Builder<T>
    implements PathResolver.Builder<T> {
        private final Map<String, Builder<T>> subBuilders;
        private final Map<String, Info<T>> infoMap;
        private final boolean throwOnConflict;
        private final PathMatcher pathMatcher;

        Builder(boolean throwOnConflict) {
            this.throwOnConflict = throwOnConflict;
            this.subBuilders = new LinkedHashMap<String, Builder<T>>();
            this.infoMap = new LinkedHashMap<String, Info<T>>();
            this.pathMatcher = new PathMatcher();
        }

        @Override
        public Builder<T> add(String method, String path, T value) {
            Objects.requireNonNull(method, "method");
            Objects.requireNonNull(path, "path");
            Objects.requireNonNull(value, "value");
            this.internalAdd(method, path, this.pathMatcher.tokenize(path).iterator(), value, new ArrayList<String>());
            return this;
        }

        @Override
        public PathResolver<T> build() {
            return new PathResolver(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void internalAdd(String method, String path, Iterator<String> pathSegments, T value, List<String> parameterNames) {
            if (pathSegments.hasNext()) {
                String segment = pathSegments.next();
                if (segment.startsWith("{")) {
                    if (!segment.endsWith("}")) throw new IllegalArgumentException("missing closed brace } in " + segment);
                    parameterNames.add(this.getAndCheckParameterName(segment));
                    this.getOrCreateSubBuilder(PathResolver.PARAMETER_PATH_SEGMENT).internalAdd(method, path, pathSegments, value, parameterNames);
                    return;
                } else if (segment.contains("**")) {
                    this.getOrCreateSubBuilder("**").internalAdd(method, path, pathSegments, value, parameterNames);
                    return;
                } else {
                    if (RESERVED_URL_CHARS.matchesAnyOf((CharSequence)segment)) {
                        throw new IllegalArgumentException("contains reserved URL character in " + segment);
                    }
                    this.getOrCreateSubBuilder(segment).internalAdd(method, path, pathSegments, value, parameterNames);
                }
                return;
            } else {
                boolean pathExists = this.infoMap.containsKey(method);
                if (pathExists && this.throwOnConflict) {
                    throw new IllegalArgumentException("path '" + path + "' is already mapped");
                }
                this.infoMap.put(method, new Info<T>(parameterNames, value, method));
            }
        }

        private String getAndCheckParameterName(String segment) {
            String name = segment.substring(1, segment.length() - 1);
            Matcher matcher = PARAMETER_NAME_PATTERN.matcher(name);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(String.format("'%s' not a valid path parameter name", name));
            }
            return name;
        }

        private Builder<T> getOrCreateSubBuilder(String segment) {
            Builder<T> subBuilder = this.subBuilders.get(segment);
            if (subBuilder == null) {
                subBuilder = PathResolver.builder(this.throwOnConflict);
                this.subBuilders.put(segment, subBuilder);
            }
            return subBuilder;
        }
    }

    private static class Info<T> {
        private final T value;
        private final List<String> parameterNames;
        private final String method;

        Info(List<String> parameterNames, T value, String method) {
            this.parameterNames = parameterNames;
            this.value = value;
            this.method = method;
        }
    }

    public static class Result<T>
    implements PathResolver.Result<T> {
        private final T value;
        private final Parameter parameter;
        private final String method;

        Result(T value, Parameter parameter, String method) {
            this.value = value;
            this.parameter = parameter;
            this.method = method;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public Parameter getParameter() {
            return this.parameter;
        }

        @Override
        public String getMethod() {
            return this.method;
        }
    }
}

