/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.net.path.simple;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xbib.net.ParameterBuilder;

public class PathStringMatcher {
    private static final Pattern GLOB_PATTERN = Pattern.compile("\\?|\\*|\\{((?:\\{[^/]+?}|[^/{}]|\\\\[{}])+?)}");
    private static final String DEFAULT_VARIABLE_PATTERN = "(.*)";
    private final String patternString;
    private final List<String> variableNames = new ArrayList<String>();
    private final Pattern pattern;

    public PathStringMatcher(String patternString, boolean caseSensitive) {
        this.patternString = patternString;
        StringBuilder sb = new StringBuilder();
        Matcher matcher = GLOB_PATTERN.matcher(patternString);
        int start = 0;
        while (matcher.find()) {
            sb.append(PathStringMatcher.quote(patternString, start, matcher.start()));
            String match = matcher.group();
            if ("?".equals(match)) {
                sb.append('.');
            } else if ("*".equals(match)) {
                sb.append(".*");
            } else if (match.startsWith("{") && match.endsWith("}")) {
                int colonIdx = match.indexOf(58);
                if (colonIdx == -1) {
                    sb.append(DEFAULT_VARIABLE_PATTERN);
                    this.variableNames.add(matcher.group(1));
                } else {
                    String variablePattern = match.substring(colonIdx + 1, match.length() - 1);
                    sb.append('(').append(variablePattern).append(')');
                    String variableName = match.substring(1, colonIdx);
                    this.variableNames.add(variableName);
                }
            }
            start = matcher.end();
        }
        sb.append(PathStringMatcher.quote(patternString, start, patternString.length()));
        this.pattern = caseSensitive ? Pattern.compile(sb.toString()) : Pattern.compile(sb.toString(), 2);
    }

    public String getPatternString() {
        return this.patternString;
    }

    public List<String> getVariableNames() {
        return this.variableNames;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public boolean match(String string, ParameterBuilder queryParameters) {
        Matcher matcher = this.pattern.matcher(string);
        if (matcher.matches()) {
            if (queryParameters != null) {
                if (this.variableNames.size() != matcher.groupCount()) {
                    throw new IllegalArgumentException("The number of capturing groups in the pattern segment " + String.valueOf(this.pattern) + " does not match the number of URI template variables it defines, which can occur if capturing groups are used in a URI template regex. Use non-capturing groups instead.");
                }
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    String name = this.variableNames.get(i - 1);
                    String value = matcher.group(i);
                    queryParameters.add(name, (Object)value);
                }
            }
            return true;
        }
        return false;
    }

    private static String quote(String s, int start, int end) {
        return start == end ? "" : Pattern.quote(s.substring(start, end));
    }
}

