/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.net.path.spring;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.xbib.net.path.spring.DefaultSeparator;
import org.xbib.net.path.spring.PathContainer;
import org.xbib.net.path.spring.util.LinkedMultiValueMap;
import org.xbib.net.path.spring.util.MultiValueMap;

final class DefaultPathContainer
implements PathContainer {
    private static final PathContainer EMPTY_PATH = new DefaultPathContainer("", Collections.emptyList());
    private static final Map<Character, DefaultSeparator> SEPARATORS = new HashMap<Character, DefaultSeparator>(2);
    private final String path;
    private final List<PathContainer.Element> elements;

    private DefaultPathContainer(String path, List<PathContainer.Element> elements) {
        this.path = path;
        this.elements = Collections.unmodifiableList(elements);
    }

    @Override
    public String value() {
        return this.path;
    }

    @Override
    public List<PathContainer.Element> elements() {
        return this.elements;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PathContainer)) {
            return false;
        }
        return this.value().equals(((PathContainer)other).value());
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return this.value();
    }

    static PathContainer createFromUrlPath(String path, PathContainer.Options options) {
        int begin;
        if (path.isEmpty()) {
            return EMPTY_PATH;
        }
        char separator = options.separator();
        DefaultSeparator separatorElement = SEPARATORS.get(Character.valueOf(separator));
        if (separatorElement == null) {
            throw new IllegalArgumentException("Unexpected separator: '" + separator + "'");
        }
        ArrayList<PathContainer.Element> elements = new ArrayList<PathContainer.Element>();
        if (path.charAt(0) == separator) {
            begin = 1;
            elements.add(separatorElement);
        } else {
            begin = 0;
        }
        while (begin < path.length()) {
            String segment;
            int end = path.indexOf(separator, begin);
            String string = segment = end != -1 ? path.substring(begin, end) : path.substring(begin);
            if (!segment.isEmpty()) {
                elements.add(options.shouldDecodeAndParseSegments() ? DefaultPathContainer.decodeAndParsePathSegment(segment) : DefaultPathSegment.from(segment, separatorElement));
            }
            if (end == -1) break;
            elements.add(separatorElement);
            begin = end + 1;
        }
        return new DefaultPathContainer(path, elements);
    }

    private static PathContainer.PathSegment decodeAndParsePathSegment(String segment) {
        Charset charset = StandardCharsets.UTF_8;
        int index = segment.indexOf(59);
        if (index == -1) {
            String valueToMatch = DefaultPathContainer.uriDecode(segment, charset);
            return DefaultPathSegment.from(segment, valueToMatch);
        }
        String valueToMatch = DefaultPathContainer.uriDecode(segment.substring(0, index), charset);
        String pathParameterContent = segment.substring(index);
        MultiValueMap<String, String> parameters = DefaultPathContainer.parsePathParams(pathParameterContent, charset);
        return DefaultPathSegment.from(segment, valueToMatch, parameters);
    }

    private static MultiValueMap<String, String> parsePathParams(String input, Charset charset) {
        LinkedMultiValueMap<String, String> result = new LinkedMultiValueMap<String, String>();
        int begin = 1;
        while (begin < input.length()) {
            int end = input.indexOf(59, begin);
            String param = end != -1 ? input.substring(begin, end) : input.substring(begin);
            DefaultPathContainer.parsePathParamValues(param, charset, result);
            if (end == -1) break;
            begin = end + 1;
        }
        return result;
    }

    private static void parsePathParamValues(String input, Charset charset, MultiValueMap<String, String> output) {
        if (DefaultPathContainer.hasText(input)) {
            int index = input.indexOf(61);
            if (index != -1) {
                String name = input.substring(0, index);
                if (DefaultPathContainer.hasText(name = DefaultPathContainer.uriDecode(name, charset))) {
                    String value = input.substring(index + 1);
                    for (String v : DefaultPathContainer.commaDelimitedListToStringArray(value)) {
                        output.add(name, DefaultPathContainer.uriDecode(v, charset));
                    }
                }
            } else {
                String name = DefaultPathContainer.uriDecode(input, charset);
                if (DefaultPathContainer.hasText(name)) {
                    output.add(input, "");
                }
            }
        }
    }

    public static boolean hasText(String str) {
        return str != null && !str.isEmpty() && DefaultPathContainer.containsText(str);
    }

    private static boolean containsText(CharSequence str) {
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static List<String> commaDelimitedListToStringArray(String str) {
        return DefaultPathContainer.delimitedListToStringArray(str, ",");
    }

    private static List<String> delimitedListToStringArray(String str, String delimiter) {
        return DefaultPathContainer.delimitedListToStringArray(str, delimiter, null);
    }

    private static List<String> delimitedListToStringArray(String str, String delimiter, String charsToDelete) {
        if (str == null) {
            return List.of();
        }
        if (delimiter == null) {
            return List.of(str);
        }
        ArrayList<String> result = new ArrayList<String>();
        if (delimiter.isEmpty()) {
            for (int i = 0; i < str.length(); ++i) {
                result.add(DefaultPathContainer.deleteAny(str.substring(i, i + 1), charsToDelete));
            }
        } else {
            int delPos;
            int pos = 0;
            while ((delPos = str.indexOf(delimiter, pos)) != -1) {
                result.add(DefaultPathContainer.deleteAny(str.substring(pos, delPos), charsToDelete));
                pos = delPos + delimiter.length();
            }
            if (str.length() > 0 && pos <= str.length()) {
                result.add(DefaultPathContainer.deleteAny(str.substring(pos), charsToDelete));
            }
        }
        return result;
    }

    private static String deleteAny(String inString, String charsToDelete) {
        if (!DefaultPathContainer.hasLength(inString) || !DefaultPathContainer.hasLength(charsToDelete)) {
            return inString;
        }
        int lastCharIndex = 0;
        char[] result = new char[inString.length()];
        for (int i = 0; i < inString.length(); ++i) {
            char c = inString.charAt(i);
            if (charsToDelete.indexOf(c) != -1) continue;
            result[lastCharIndex++] = c;
        }
        if (lastCharIndex == inString.length()) {
            return inString;
        }
        return new String(result, 0, lastCharIndex);
    }

    private static boolean hasLength(String str) {
        return str != null && !str.isEmpty();
    }

    private static String uriDecode(String source, Charset charset) {
        int length = source.length();
        if (length == 0) {
            return source;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(length);
        boolean changed = false;
        for (int i = 0; i < length; ++i) {
            char ch = source.charAt(i);
            if (ch == '%') {
                if (i + 2 < length) {
                    char hex1 = source.charAt(i + 1);
                    char hex2 = source.charAt(i + 2);
                    int u = Character.digit(hex1, 16);
                    int l = Character.digit(hex2, 16);
                    if (u == -1 || l == -1) {
                        throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
                    }
                    baos.write((char)((u << 4) + l));
                    i += 2;
                    changed = true;
                    continue;
                }
                throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
            }
            baos.write(ch);
        }
        return changed ? baos.toString(charset) : source;
    }

    static PathContainer subPath(PathContainer container, int fromIndex, int toIndex) {
        List<PathContainer.Element> elements = container.elements();
        if (fromIndex == 0 && toIndex == elements.size()) {
            return container;
        }
        if (fromIndex == toIndex) {
            return EMPTY_PATH;
        }
        List<PathContainer.Element> subList = elements.subList(fromIndex, toIndex);
        String path = subList.stream().map(PathContainer.Element::value).collect(Collectors.joining(""));
        return new DefaultPathContainer(path, subList);
    }

    static {
        SEPARATORS.put(Character.valueOf('/'), new DefaultSeparator('/', "%2F"));
        SEPARATORS.put(Character.valueOf('.'), new DefaultSeparator('.', "%2E"));
    }

    private static final class DefaultPathSegment
    implements PathContainer.PathSegment {
        private static final MultiValueMap<String, String> EMPTY_PARAMS = new LinkedMultiValueMap<String, String>();
        private final String value;
        private final String valueToMatch;
        private final MultiValueMap<String, String> parameters;

        static DefaultPathSegment from(String value, DefaultSeparator separator) {
            String valueToMatch = value.contains(separator.encodedSequence()) ? value.replaceAll(separator.encodedSequence(), separator.value()) : value;
            return DefaultPathSegment.from(value, valueToMatch);
        }

        static DefaultPathSegment from(String value, String valueToMatch) {
            return new DefaultPathSegment(value, valueToMatch, EMPTY_PARAMS);
        }

        static DefaultPathSegment from(String value, String valueToMatch, MultiValueMap<String, String> params) {
            return new DefaultPathSegment(value, valueToMatch, params);
        }

        private DefaultPathSegment(String value, String valueToMatch, MultiValueMap<String, String> params) {
            this.value = value;
            this.valueToMatch = valueToMatch;
            this.parameters = params;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public String valueToMatch() {
            return this.valueToMatch;
        }

        @Override
        public char[] valueToMatchAsChars() {
            return this.valueToMatch.toCharArray();
        }

        @Override
        public MultiValueMap<String, String> parameters() {
            return this.parameters;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PathContainer.PathSegment)) {
                return false;
            }
            return this.value().equals(((PathContainer.PathSegment)other).value());
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "[value='" + this.value + "']";
        }
    }
}

